/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class IsolatedClassLoader
extends URLClassLoader {
    private final ClassLoader parent = ClassLoader.getSystemClassLoader();
    private final Set<URL> urls = new HashSet<URL>();
    private boolean childDelegation = true;
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];

    public IsolatedClassLoader(ClassLoader parent, boolean childDelegation) {
        super(EMPTY_URL_ARRAY, parent);
        this.childDelegation = childDelegation;
    }

    public IsolatedClassLoader() {
        super(EMPTY_URL_ARRAY, ClassLoader.getSystemClassLoader());
        this.childDelegation = true;
    }

    @Override
    public void addURL(URL url) {
        if (!this.urls.contains(url)) {
            super.addURL(url);
            this.urls.add(url);
        }
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        Class<?> c;
        if (this.childDelegation) {
            ClassNotFoundException ex;
            block6: {
                c = this.findLoadedClass(name);
                ex = null;
                if (c == null) {
                    try {
                        c = this.findClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        ex = e;
                        if (this.parent == null) break block6;
                        c = this.parent.loadClass(name);
                    }
                }
            }
            if (c == null) {
                throw ex;
            }
        } else {
            c = super.loadClass(name);
        }
        return c;
    }
}

