/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.Dictionary;
import java.util.Map;
import org.apache.felix.log.LoggerAdminImpl;
import org.apache.felix.log.LoggerContextImpl;
import org.osgi.service.log.LogLevel;

public class RootLoggerContextImpl
extends LoggerContextImpl {
    private final LogLevel _defaultLevel;

    public RootLoggerContextImpl(String defaultLogLevelString, LoggerAdminImpl loggerAdminImpl) {
        super(null, loggerAdminImpl, null);
        LogLevel defaultLogLevel = LogLevel.WARN;
        if (defaultLogLevelString != null) {
            for (LogLevel level : LogLevel.values()) {
                if (!level.name().equalsIgnoreCase(defaultLogLevelString)) continue;
                defaultLogLevel = level;
                break;
            }
        }
        this._defaultLevel = defaultLogLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogLevel getEffectiveLogLevel(String name) {
        this._lock.lock();
        try {
            if (this._levels != null && !this._levels.isEmpty()) {
                while (name.length() > 0) {
                    LogLevel level = (LogLevel)((Object)this._levels.get(name));
                    if (level != null) {
                        LogLevel logLevel = level;
                        return logLevel;
                    }
                    if ("ROOT".equals(name)) break;
                    name = this.ancestor(name);
                }
            }
            LogLevel logLevel = this.getEffectiveRootLogLevel();
            return logLevel;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void setLogLevels(Map<String, LogLevel> logLevels) {
        super.setLogLevels(logLevels);
    }

    @Override
    void updateLoggerContext(Dictionary<String, Object> properties) {
        super.updateLoggerContext(properties);
    }

    private LogLevel getEffectiveRootLogLevel() {
        if (this._levels == null) {
            return this._defaultLevel;
        }
        LogLevel logLevel = (LogLevel)((Object)this._levels.get("ROOT"));
        return logLevel == null ? this._defaultLevel : logLevel;
    }
}

