/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.felix.upnp.tester.discovery.DeviceNode;
import org.apache.felix.upnp.tester.gui.UPnPDeviceTreeNode;

class TreeNodeCellRenderer
extends DefaultTreeCellRenderer
implements ImageObserver {
    private HashMap icons = new HashMap();
    ImageIcon image;
    static /* synthetic */ Class class$org$apache$felix$upnp$tester$gui$UPnPDeviceTreeNode;

    public TreeNodeCellRenderer() {
        try {
            this.icons.put("EventedStateVariable", TreeNodeCellRenderer.loadIcon("EventedStateVariable"));
            this.image = TreeNodeCellRenderer.loadIcon("SubscribedStateVariable");
            this.icons.put("SubscribedStateVariable", this.image);
            this.icons.put("RootDeviceNode", TreeNodeCellRenderer.loadIcon("RootDeviceNode"));
            this.icons.put("DeviceNode", TreeNodeCellRenderer.loadIcon("DeviceNode"));
            this.icons.put("UPnPService", TreeNodeCellRenderer.loadIcon("UPnPService"));
            this.icons.put("UPnPAction", TreeNodeCellRenderer.loadIcon("UPnPAction"));
            this.icons.put("UPnPStateVariable", TreeNodeCellRenderer.loadIcon("UPnPStateVariable"));
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public JToolTip createToolTip() {
        JToolTip tip = super.createToolTip();
        tip.setBackground(Color.yellow);
        return tip;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon icon = this.selectIcon((UPnPDeviceTreeNode)value);
        this.setToolTip((UPnPDeviceTreeNode)value);
        if (icon != null) {
            this.setOpenIcon(icon);
            this.setClosedIcon(icon);
            this.setLeafIcon(icon);
        } else {
            this.setOpenIcon(this.getDefaultOpenIcon());
            this.setClosedIcon(this.getDefaultClosedIcon());
            this.setLeafIcon(this.getDefaultLeafIcon());
        }
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public Icon selectIcon(UPnPDeviceTreeNode node) {
        Icon icon = null;
        try {
            String tag = node.category;
            icon = (Icon)this.icons.get(tag);
        }
        catch (Exception ex) {
            System.out.println("getTreeCellRendererComponent Exception:" + ex);
        }
        return icon;
    }

    public void setToolTip(UPnPDeviceTreeNode node) {
        String tag = node.category;
        if (tag.equals("RootDeviceNode") || tag.equals("DeviceNode")) {
            DeviceNode device = (DeviceNode)node.getUserObject();
            this.setToolTipText("<html><TABLE BORDER='0' CELLPADDING='0' CELLSPACING='0' ><TR BGCOLOR='#F9FF79' ><TD>" + device.getReference().getProperty("UPnP.device.friendlyName").toString() + "</TD></TR></TABLE ></html>");
        } else {
            this.setToolTipText(null);
        }
    }

    public static ImageIcon loadIcon(String name) {
        try {
            URL eventIconUrl = (class$org$apache$felix$upnp$tester$gui$UPnPDeviceTreeNode == null ? (class$org$apache$felix$upnp$tester$gui$UPnPDeviceTreeNode = TreeNodeCellRenderer.class$("org.apache.felix.upnp.tester.gui.UPnPDeviceTreeNode")) : class$org$apache$felix$upnp$tester$gui$UPnPDeviceTreeNode).getResource("IMAGES/" + name + ".gif");
            return new ImageIcon(eventIconUrl, name);
        }
        catch (Exception ex) {
            System.out.println("Resource:" + name + " not found : " + ex.toString());
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

