/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.lang;

import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.DesignLayerNode;
import flex2.compiler.mxml.dom.DocumentNode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.LayeredNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.ReparentNode;
import flex2.compiler.mxml.dom.StateNode;
import flex2.compiler.mxml.dom.VectorNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.reflect.Assignable;
import flex2.compiler.mxml.rep.MxmlDocument;

public abstract class ValueNodeHandler {
    protected abstract void componentNode(Assignable var1, Node var2, MxmlDocument var3);

    protected abstract void arrayNode(Assignable var1, ArrayNode var2);

    protected abstract void primitiveNode(Assignable var1, PrimitiveNode var2);

    protected abstract void xmlNode(Assignable var1, XMLNode var2);

    protected abstract void xmlListNode(Assignable var1, XMLListNode var2);

    protected abstract void modelNode(Assignable var1, ModelNode var2);

    protected abstract void reparentNode(Assignable var1, ReparentNode var2);

    protected abstract void stateNode(Assignable var1, StateNode var2);

    protected abstract void inlineComponentNode(Assignable var1, InlineComponentNode var2);

    protected abstract void cdataNode(Assignable var1, CDATANode var2);

    protected abstract void vectorNode(Assignable var1, VectorNode var2);

    protected abstract void unknown(Assignable var1, Node var2);

    public static boolean isValueNode(Node node) {
        Class<?> nodeClass = node.getClass();
        return nodeClass == Node.class || nodeClass == LayeredNode.class || nodeClass == DocumentNode.class || nodeClass == ArrayNode.class || node instanceof PrimitiveNode || nodeClass == XMLNode.class || nodeClass == XMLListNode.class || nodeClass == ModelNode.class || nodeClass == ReparentNode.class || nodeClass == InlineComponentNode.class || nodeClass == VectorNode.class;
    }

    public void invoke(Assignable property, Node node, MxmlDocument document) {
        Class<?> nodeClass = node.getClass();
        if (nodeClass == Node.class || nodeClass == LayeredNode.class || nodeClass == DesignLayerNode.class || nodeClass == DocumentNode.class) {
            this.componentNode(property, node, document);
        } else if (nodeClass == ArrayNode.class) {
            this.arrayNode(property, (ArrayNode)node);
        } else if (node instanceof PrimitiveNode) {
            this.primitiveNode(property, (PrimitiveNode)node);
        } else if (nodeClass == XMLNode.class) {
            this.xmlNode(property, (XMLNode)node);
        } else if (nodeClass == XMLListNode.class) {
            this.xmlListNode(property, (XMLListNode)node);
        } else if (nodeClass == ModelNode.class) {
            this.modelNode(property, (ModelNode)node);
        } else if (nodeClass == InlineComponentNode.class) {
            this.inlineComponentNode(property, (InlineComponentNode)node);
        } else if (nodeClass == ReparentNode.class) {
            this.reparentNode(property, (ReparentNode)node);
        } else if (nodeClass == StateNode.class) {
            this.stateNode(property, (StateNode)node);
        } else if (nodeClass == CDATANode.class) {
            this.cdataNode(property, (CDATANode)node);
        } else if (nodeClass == VectorNode.class) {
            this.vectorNode(property, (VectorNode)node);
        } else {
            assert (!ValueNodeHandler.isValueNode(node)) : "value node class not handled by invoke()";
            this.unknown(property, node);
        }
    }
}

