/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Digest {
    public static final String SHA_256 = "SHA-256";
    private String type = "SHA-256";
    private String value;
    private boolean signed;

    public Digest() {
        this(false);
    }

    public Digest(boolean signed) {
        this.signed = signed;
    }

    public String getType() {
        return this.type == null ? "" : this.type;
    }

    public void setType(String hashType) {
        this.type = hashType;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public String computeDigest(byte[] byteArray) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(this.type);
        }
        catch (NoSuchAlgorithmException e) {
            this.value = "Hash not supported";
            return this.value;
        }
        byte[] digestBytes = digest.digest(byteArray);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < digestBytes.length; ++i) {
            String s = Integer.toHexString(digestBytes[i] & 0xFF);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        this.value = buf.toString();
        return this.value;
    }

    public boolean hasDigest() {
        return this.value != null;
    }
}

