/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import flash.util.AbstractCache;
import java.util.HashMap;
import java.util.Set;

public abstract class LRUCache
extends AbstractCache {
    private HashMap<Object, LRUListEntry> map;
    private LRUListEntry head;
    private LRUListEntry tail;
    private int maxSize;
    private int purgeSize = 1;

    public LRUCache(int initialSize, int maxSize) {
        this(initialSize, maxSize, 1);
    }

    public LRUCache(int initialSize, int maxSize, int purgeSize) {
        this.maxSize = maxSize;
        this.purgeSize = purgeSize;
        this.map = new HashMap(initialSize);
        this.head = null;
        this.tail = null;
    }

    public synchronized Set entrySet() {
        return this.map.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object value = null;
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            if (this.head != null && key == this.head.key) {
                return this.head.value;
            }
            LRUListEntry entry = this.map.get(key);
            if (entry != null) {
                ++this.hits;
                ++entry.hits;
                this.setMostRecentlyUsed(entry);
                return entry.value;
            }
            ++this.misses;
            this.rmStats(entry);
        }
        long before = System.currentTimeMillis();
        value = this.fetch(key);
        int penalty = (int)(System.currentTimeMillis() - before);
        this.missPenalty += (long)penalty;
        this.put(key, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, Object value) {
        LRUListEntry entry = new LRUListEntry();
        entry.value = value;
        entry.key = key;
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            this.remove(key);
            this.map.put(key, entry);
            this.setMostRecentlyUsed(entry);
            if (this.tail == null) {
                this.tail = entry;
            }
            if (this.map.size() > this.maxSize) {
                this.purgeLRUElements();
            }
            this.rmStats(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            LRUListEntry entry = this.map.remove(key);
            if (entry != null) {
                if (entry == this.head) {
                    this.head = entry.next;
                }
                if (entry == this.tail) {
                    this.tail = entry.prev;
                }
                if (entry.prev != null) {
                    entry.prev.next = entry.next;
                    assert (entry.prev.next != entry.prev);
                }
                if (entry.next != null) {
                    entry.next.prev = entry.prev;
                    assert (entry.next.prev != entry.next);
                }
            }
            this.rmStats(entry);
        }
    }

    public void setSize(int size) {
    }

    public synchronized void clear() {
        this.map.clear();
        this.head = null;
        this.tail = null;
    }

    public int size() {
        int s = this.map.size();
        LRUListEntry e = this.head;
        int num = 0;
        while (e != null) {
            ++num;
            e = e.next;
        }
        if (s != num) assert (false) : "Memory leak in LRUCache!";
        return s;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getPurgeSize() {
        return this.purgeSize;
    }

    protected void handleLRUElementPurged(Object key, Object value) {
    }

    private void rmStats(LRUListEntry ref) {
        if (ref != null) {
            this.hits -= (long)ref.hits;
            --this.misses;
            if (ref.penalty != -1) {
                ref.getClass();
                this.missPenalty -= -1L;
            }
        }
    }

    private void purgeLRUElements() {
        for (int i = 0; i < this.purgeSize && this.tail != null; ++i) {
            Object key = this.tail.key;
            Object value = this.tail.value;
            this.remove(this.tail.key);
            this.handleLRUElementPurged(key, value);
        }
    }

    private void setMostRecentlyUsed(LRUListEntry entry) {
        if (entry == this.head) {
            return;
        }
        if (entry.prev != null) {
            entry.prev.next = entry.next;
            assert (entry.prev.next != entry.prev);
            if (entry == this.tail) {
                this.tail = entry.prev;
                this.tail.next = null;
            }
        }
        if (entry.next != null) {
            entry.next.prev = entry.prev;
            assert (entry.next.prev != entry.next);
        }
        entry.prev = null;
        entry.next = this.head;
        assert (entry.next != entry);
        if (this.head != null) {
            this.head.prev = entry;
            assert (this.head.prev != this.head);
        }
        this.head = entry;
    }

    protected class LRUListEntry {
        LRUListEntry next;
        LRUListEntry prev;
        Object value;
        Object key;
        int hits;
        final int penalty = -1;

        protected LRUListEntry() {
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

