/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.tasks.configuration;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.tasks.configuration.StepConfiguration;
import org.flexunit.ant.tasks.types.LibraryPaths;
import org.flexunit.ant.tasks.types.LoadConfig;
import org.flexunit.ant.tasks.types.SourcePaths;

public class CompilationConfiguration
implements StepConfiguration {
    private SourcePaths sources = new SourcePaths();
    private SourcePaths testSources = new SourcePaths();
    private LibraryPaths libraries = new LibraryPaths();
    private File flexHome;
    private String player;
    private File workingDir;
    private boolean debug = false;
    private LoadConfig loadConfig;

    public File getFlexHome() {
        return this.flexHome;
    }

    public void setFlexHome(File file) {
        this.flexHome = file;
    }

    public void addLibrary(FileSet fileSet) {
        this.libraries.add(fileSet);
    }

    public LibraryPaths getLibraries() {
        return this.libraries;
    }

    public String getPlayer() {
        return this.player;
    }

    public void setPlayer(String string) {
        this.player = string;
    }

    public void addSource(FileSet fileSet) {
        this.sources.add(fileSet);
    }

    public SourcePaths getSources() {
        return this.sources;
    }

    public void addTestSource(FileSet fileSet) {
        this.testSources.add(fileSet);
    }

    public SourcePaths getTestSources() {
        return this.testSources;
    }

    public void setWorkingDir(File file) {
        this.workingDir = file;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void validate() throws BuildException {
        if (!this.testSources.exists()) {
            throw new BuildException("One of the directories specified as a 'testSource' element does not exist.");
        }
        if (this.testSources.exists() && this.testSources.isEmpty()) {
            throw new BuildException("No test files could be found for the provided 'testSource' elements.");
        }
        if (!this.libraries.exists()) {
            throw new BuildException("One of the directories specified as a 'library' element does not exist.");
        }
        if (this.libraries.exists() && this.libraries.isEmpty() && this.loadConfig == null) {
            throw new BuildException("'library' elements not specified or 'load-config' element not specified. Also possible no SWC files could be found for the provided 'library' elements.");
        }
    }

    public void log() {
        LoggingUtil.log("Using the following settings for compilation:");
        LoggingUtil.log("\tFLEX_HOME: [" + this.flexHome.getAbsolutePath() + "]");
        LoggingUtil.log("\tplayer: [" + this.player + "]");
        LoggingUtil.log("\tsourceDirectories: [" + this.sources.getPathElements(",") + "]");
        LoggingUtil.log("\ttestSourceDirectories: [" + this.testSources.getPathElements(",") + "]");
        LoggingUtil.log("\tlibraries: [" + this.libraries.getPathElements(",") + "]");
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setLoadConfig(LoadConfig loadConfig) {
        this.loadConfig = loadConfig;
    }

    public LoadConfig getLoadConfig() {
        return this.loadConfig;
    }
}

