/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.connector.sink.abilities.SupportsDeletePushDown;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.ModifyOperationVisitor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SinkModifyOperation;
import org.apache.flink.util.Preconditions;

@Internal
public class DeleteFromFilterOperation
extends SinkModifyOperation {
    @Nonnull
    private final SupportsDeletePushDown supportsDeletePushDownSink;
    @Nonnull
    private final List<ResolvedExpression> filters;

    public DeleteFromFilterOperation(ContextResolvedTable contextResolvedTable, @Nonnull SupportsDeletePushDown supportsDeletePushDownSink, @Nonnull List<ResolvedExpression> filters) {
        super(contextResolvedTable, null, SinkModifyOperation.ModifyType.DELETE);
        this.supportsDeletePushDownSink = (SupportsDeletePushDown)Preconditions.checkNotNull((Object)supportsDeletePushDownSink);
        this.filters = (List)Preconditions.checkNotNull(filters);
    }

    @Nonnull
    public SupportsDeletePushDown getSupportsDeletePushDownSink() {
        return this.supportsDeletePushDownSink;
    }

    @Nonnull
    public List<ResolvedExpression> getFilters() {
        return this.filters;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.getContextResolvedTable().getIdentifier().asSummaryString());
        params.put("filters", this.filters);
        return OperationUtils.formatWithChildren("DeleteFromFilter", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public QueryOperation getChild() {
        throw new UnsupportedOperationException("This shouldn't be called");
    }

    @Override
    public <T> T accept(ModifyOperationVisitor<T> visitor) {
        throw new UnsupportedOperationException("This shouldn't be called");
    }
}

