/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ExtractionVersion;
import org.apache.flink.table.annotation.HintFlag;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.extraction.ExtractionUtils;

@Internal
final class DataTypeTemplate {
    private static final DataTypeHint DEFAULT_ANNOTATION = DataTypeTemplate.getDefaultAnnotation();
    private static final String RAW_TYPE_NAME = "RAW";
    @Nullable
    final DataType dataType;
    @Nullable
    final Class<? extends TypeSerializer<?>> rawSerializer;
    @Nullable
    final InputGroup inputGroup;
    @Nullable
    final ExtractionVersion version;
    @Nullable
    final Boolean allowRawGlobally;
    @Nullable
    final String[] allowRawPattern;
    @Nullable
    final String[] forceRawPattern;
    @Nullable
    final Integer defaultDecimalPrecision;
    @Nullable
    final Integer defaultDecimalScale;
    @Nullable
    final Integer defaultYearPrecision;
    @Nullable
    final Integer defaultSecondPrecision;

    private DataTypeTemplate(@Nullable DataType dataType, @Nullable Class<? extends TypeSerializer<?>> rawSerializer, @Nullable InputGroup inputGroup, @Nullable ExtractionVersion version, @Nullable Boolean allowRawGlobally, @Nullable String[] allowRawPattern, @Nullable String[] forceRawPattern, @Nullable Integer defaultDecimalPrecision, @Nullable Integer defaultDecimalScale, @Nullable Integer defaultYearPrecision, @Nullable Integer defaultSecondPrecision) {
        this.dataType = dataType;
        this.rawSerializer = rawSerializer;
        this.inputGroup = inputGroup;
        this.version = version;
        this.allowRawGlobally = allowRawGlobally;
        this.allowRawPattern = allowRawPattern;
        this.forceRawPattern = forceRawPattern;
        this.defaultDecimalPrecision = defaultDecimalPrecision;
        this.defaultDecimalScale = defaultDecimalScale;
        this.defaultYearPrecision = defaultYearPrecision;
        this.defaultSecondPrecision = defaultSecondPrecision;
    }

    static DataTypeTemplate fromAnnotation(DataTypeFactory typeFactory, DataTypeHint hint) {
        String typeName = DataTypeTemplate.defaultAsNull(hint, DataTypeHint::value);
        Class conversionClass = DataTypeTemplate.defaultAsNull(hint, DataTypeHint::bridgedTo);
        if (typeName != null || conversionClass != null) {
            DataTypeTemplate extractionTemplate = DataTypeTemplate.fromAnnotation(hint, null);
            return DataTypeTemplate.fromAnnotation(hint, DataTypeTemplate.extractDataType(typeFactory, typeName, conversionClass, extractionTemplate));
        }
        return DataTypeTemplate.fromAnnotation(hint, null);
    }

    static DataTypeTemplate fromAnnotation(DataTypeHint hint, @Nullable DataType dataType) {
        return new DataTypeTemplate(dataType, DataTypeTemplate.defaultAsNull(hint, DataTypeHint::rawSerializer), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::inputGroup), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::version), DataTypeTemplate.hintFlagToBoolean(DataTypeTemplate.defaultAsNull(hint, DataTypeHint::allowRawGlobally)), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::allowRawPattern), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::forceRawPattern), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::defaultDecimalPrecision), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::defaultDecimalScale), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::defaultYearPrecision), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::defaultSecondPrecision));
    }

    static DataTypeTemplate fromDefaults() {
        return new DataTypeTemplate(null, null, null, null, null, null, null, null, null, null, null);
    }

    DataTypeTemplate copyWithoutDataType() {
        return new DataTypeTemplate(null, this.rawSerializer, this.inputGroup, this.version, this.allowRawGlobally, this.allowRawPattern, this.forceRawPattern, this.defaultDecimalPrecision, this.defaultDecimalScale, this.defaultYearPrecision, this.defaultSecondPrecision);
    }

    DataTypeTemplate mergeWithInnerAnnotation(DataTypeFactory typeFactory, DataTypeHint hint) {
        DataTypeTemplate otherTemplate = DataTypeTemplate.fromAnnotation(typeFactory, hint);
        return new DataTypeTemplate(otherTemplate.dataType, DataTypeTemplate.rightValueIfNotNull(this.rawSerializer, otherTemplate.rawSerializer), DataTypeTemplate.rightValueIfNotNull(this.inputGroup, otherTemplate.inputGroup), DataTypeTemplate.rightValueIfNotNull(this.version, otherTemplate.version), DataTypeTemplate.rightValueIfNotNull(this.allowRawGlobally, otherTemplate.allowRawGlobally), DataTypeTemplate.rightValueIfNotNull(this.allowRawPattern, otherTemplate.allowRawPattern), DataTypeTemplate.rightValueIfNotNull(this.forceRawPattern, otherTemplate.forceRawPattern), DataTypeTemplate.rightValueIfNotNull(this.defaultDecimalPrecision, otherTemplate.defaultDecimalPrecision), DataTypeTemplate.rightValueIfNotNull(this.defaultDecimalScale, otherTemplate.defaultDecimalScale), DataTypeTemplate.rightValueIfNotNull(this.defaultYearPrecision, otherTemplate.defaultYearPrecision), DataTypeTemplate.rightValueIfNotNull(this.defaultSecondPrecision, otherTemplate.defaultSecondPrecision));
    }

    boolean isAllowRawGlobally() {
        return this.allowRawGlobally != null && this.allowRawGlobally != false;
    }

    boolean isAllowAnyPattern(@Nullable Class<?> clazz) {
        if (this.allowRawPattern == null || clazz == null) {
            return false;
        }
        String className = clazz.getName();
        for (String pattern : this.allowRawPattern) {
            if (!className.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    boolean isForceAnyPattern(@Nullable Class<?> clazz) {
        if (this.forceRawPattern == null || clazz == null) {
            return false;
        }
        String className = clazz.getName();
        for (String pattern : this.forceRawPattern) {
            if (!className.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTypeTemplate that = (DataTypeTemplate)o;
        return Objects.equals(this.dataType, that.dataType) && Objects.equals(this.rawSerializer, that.rawSerializer) && Objects.equals((Object)this.inputGroup, (Object)that.inputGroup) && this.version == that.version && Objects.equals(this.allowRawGlobally, that.allowRawGlobally) && Arrays.equals(this.allowRawPattern, that.allowRawPattern) && Arrays.equals(this.forceRawPattern, that.forceRawPattern) && Objects.equals(this.defaultDecimalPrecision, that.defaultDecimalPrecision) && Objects.equals(this.defaultDecimalScale, that.defaultDecimalScale) && Objects.equals(this.defaultYearPrecision, that.defaultYearPrecision) && Objects.equals(this.defaultSecondPrecision, that.defaultSecondPrecision);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.dataType, this.rawSerializer, this.inputGroup, this.version, this.allowRawGlobally, this.defaultDecimalPrecision, this.defaultDecimalScale, this.defaultYearPrecision, this.defaultSecondPrecision});
        result = 31 * result + Arrays.hashCode(this.allowRawPattern);
        result = 31 * result + Arrays.hashCode(this.forceRawPattern);
        return result;
    }

    private static DataTypeHint getDefaultAnnotation() {
        return DefaultAnnotationHelper.class.getAnnotation(DataTypeHint.class);
    }

    private static <T> T defaultAsNull(DataTypeHint hint, Function<DataTypeHint, T> accessor) {
        T actualValue;
        T defaultValue = accessor.apply(DEFAULT_ANNOTATION);
        if (Objects.deepEquals(defaultValue, actualValue = accessor.apply(hint))) {
            return null;
        }
        return actualValue;
    }

    private static <T> T rightValueIfNotNull(T l, T r) {
        if (r != null) {
            return r;
        }
        return l;
    }

    private static Boolean hintFlagToBoolean(HintFlag flag) {
        if (flag == null) {
            return null;
        }
        return flag == HintFlag.TRUE;
    }

    private static DataType extractDataType(DataTypeFactory typeFactory, @Nullable String typeName, @Nullable Class<?> conversionClass, DataTypeTemplate template) {
        if (typeName != null) {
            if (typeName.equals(RAW_TYPE_NAME)) {
                return ExtractionUtils.createRawType(typeFactory, template.rawSerializer, conversionClass);
            }
            DataType resolvedDataType = typeFactory.createDataType(typeName);
            if (conversionClass != null) {
                return (DataType)resolvedDataType.bridgedTo(conversionClass);
            }
            return resolvedDataType;
        }
        if (conversionClass != null) {
            return DataTypeExtractor.extractFromType(typeFactory, template, conversionClass);
        }
        throw ExtractionUtils.extractionError("Data type hint does neither specify an explicit data type or conversion class from which a data type could be extracted.", new Object[0]);
    }

    @DataTypeHint
    private static class DefaultAnnotationHelper {
        private DefaultAnnotationHelper() {
        }
    }
}

