/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.assigners;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.window.CountWindow;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.internal.InternalWindowProcessFunction;

public class CountSlidingWindowAssigner
extends WindowAssigner<CountWindow> {
    private static final long serialVersionUID = 1923778575471995671L;
    private final long windowSize;
    private final long windowSlide;
    private transient ValueState<Long> count;

    private CountSlidingWindowAssigner(long windowSize, long windowSlide) {
        if (windowSize <= 0L || windowSlide <= 0L) {
            throw new IllegalArgumentException("SlidingCountWindowAssigner parameters must satisfy slide > 0 and size > 0");
        }
        this.windowSize = windowSize;
        this.windowSlide = windowSlide;
    }

    @Override
    public void open(InternalWindowProcessFunction.Context<?, CountWindow> ctx) throws Exception {
        String descriptorName = "slide-count-assigner";
        ValueStateDescriptor countDescriptor = new ValueStateDescriptor(descriptorName, Types.LONG);
        this.count = (ValueState)ctx.getPartitionedState(countDescriptor);
    }

    @Override
    public Collection<CountWindow> assignWindows(RowData element, long timestamp) throws IOException {
        Long countValue = (Long)this.count.value();
        long currentCount = countValue == null ? 0L : countValue;
        this.count.update((Object)(currentCount + 1L));
        long lastId = currentCount / this.windowSlide;
        long lastStart = lastId * this.windowSlide;
        ArrayList<CountWindow> windows = new ArrayList<CountWindow>();
        for (long lastEnd = lastStart + this.windowSize - 1L; lastId >= 0L && lastStart <= currentCount && currentCount <= lastEnd; --lastId, lastStart -= this.windowSlide, lastEnd -= this.windowSlide) {
            if (lastStart > currentCount || currentCount > lastEnd) continue;
            windows.add(new CountWindow(lastId));
        }
        return windows;
    }

    @Override
    public TypeSerializer<CountWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new CountWindow.Serializer();
    }

    @Override
    public boolean isEventTime() {
        return false;
    }

    @Override
    public String toString() {
        return "CountSlidingWindow(" + this.windowSize + ", " + this.windowSlide + ")";
    }

    public static CountSlidingWindowAssigner of(long windowSize, long windowSlide) {
        return new CountSlidingWindowAssigner(windowSize, windowSlide);
    }
}

