/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.aggregation.AggregationFunction;
import org.apache.flink.api.java.aggregation.AggregationFunctionFactory;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import scala.Product;

@Deprecated
@Public
public class ScalaAggregateOperator<IN>
extends SingleInputOperator<IN, IN, ScalaAggregateOperator<IN>> {
    private final List<AggregationFunction<?>> aggregationFunctions = new ArrayList(4);
    private final List<Integer> fields = new ArrayList<Integer>(4);
    private final Grouping<IN> grouping;

    public ScalaAggregateOperator(DataSet<IN> input, Aggregations function, int field2) {
        super((DataSet)Preconditions.checkNotNull(input), input.getType());
        Preconditions.checkNotNull((Object)function);
        if (!input.getType().isTupleType()) {
            throw new InvalidProgramException("Aggregating on field positions is only possible on tuple data types.");
        }
        TupleTypeInfoBase inType = (TupleTypeInfoBase)input.getType();
        if (field2 < 0 || field2 >= inType.getArity()) {
            throw new IllegalArgumentException("Aggregation field position is out of range.");
        }
        AggregationFunctionFactory factory = function.getFactory();
        AggregationFunction aggFunct = factory.createAggregationFunction(inType.getTypeAt(field2).getTypeClass());
        this.aggregationFunctions.add(aggFunct);
        this.fields.add(field2);
        this.grouping = null;
    }

    public ScalaAggregateOperator(Grouping<IN> input, Aggregations function, int field2) {
        super(((Grouping)Preconditions.checkNotNull(input)).getInputDataSet(), input.getInputDataSet().getType());
        Preconditions.checkNotNull((Object)function);
        if (!input.getInputDataSet().getType().isTupleType()) {
            throw new InvalidProgramException("Aggregating on field positions is only possible on tuple data types.");
        }
        TupleTypeInfoBase inType = (TupleTypeInfoBase)input.getInputDataSet().getType();
        if (field2 < 0 || field2 >= inType.getArity()) {
            throw new IllegalArgumentException("Aggregation field position is out of range.");
        }
        AggregationFunctionFactory factory = function.getFactory();
        AggregationFunction aggFunct = factory.createAggregationFunction(inType.getTypeAt(field2).getTypeClass());
        this.aggregationFunctions.add(aggFunct);
        this.fields.add(field2);
        this.grouping = input;
    }

    public ScalaAggregateOperator<IN> and(Aggregations function, int field2) {
        Preconditions.checkNotNull((Object)function);
        TupleTypeInfoBase inType = (TupleTypeInfoBase)this.getType();
        if (field2 < 0 || field2 >= inType.getArity()) {
            throw new IllegalArgumentException("Aggregation field position is out of range.");
        }
        AggregationFunctionFactory factory = function.getFactory();
        AggregationFunction aggFunct = factory.createAggregationFunction(inType.getTypeAt(field2).getTypeClass());
        this.aggregationFunctions.add(aggFunct);
        this.fields.add(field2);
        return this;
    }

    protected GroupReduceOperatorBase<IN, IN, GroupReduceFunction<IN, IN>> translateToDataFlow(Operator<IN> input) {
        String name;
        if (this.aggregationFunctions.isEmpty() || this.aggregationFunctions.size() != this.fields.size()) {
            throw new IllegalStateException();
        }
        AggregationFunction[] aggFunctions = new AggregationFunction[this.aggregationFunctions.size()];
        int[] fields = new int[this.fields.size()];
        StringBuilder genName = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            aggFunctions[i] = this.aggregationFunctions.get(i);
            fields[i] = this.fields.get(i);
            genName.append(aggFunctions[i].toString()).append('(').append(fields[i]).append(')').append(',');
        }
        genName.setLength(genName.length() - 1);
        AggregatingUdf function = new AggregatingUdf(this.getInputType(), aggFunctions, fields);
        String string = name = this.getName() != null ? this.getName() : genName.toString();
        if (this.grouping == null) {
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(function, operatorInfo, new int[0], name);
            po.setCombinable(true);
            po.setInput(input);
            po.setParallelism(this.getParallelism());
            return po;
        }
        if (this.grouping.getKeys() instanceof Keys.ExpressionKeys) {
            int[] logicalKeyPositions = this.grouping.getKeys().computeLogicalKeyPositions();
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(function, operatorInfo, logicalKeyPositions, name);
            po.setCombinable(true);
            po.setInput(input);
            po.setParallelism(this.getParallelism());
            SingleInputSemanticProperties props = new SingleInputSemanticProperties();
            for (int keyField : logicalKeyPositions) {
                boolean keyFieldUsedInAgg = false;
                for (int aggField : fields) {
                    if (keyField != aggField) continue;
                    keyFieldUsedInAgg = true;
                    break;
                }
                if (keyFieldUsedInAgg) continue;
                props.addForwardedField(keyField, keyField);
            }
            po.setSemanticProperties(props);
            po.setCustomPartitioner(this.grouping.getCustomPartitioner());
            return po;
        }
        if (this.grouping.getKeys() instanceof Keys.SelectorFunctionKeys) {
            throw new UnsupportedOperationException("Aggregate does not support grouping with KeySelector functions, yet.");
        }
        throw new UnsupportedOperationException("Unrecognized key type.");
    }

    @Internal
    private static final class AggregatingUdf<T extends Product>
    extends RichGroupReduceFunction<T, T>
    implements GroupCombineFunction<T, T> {
        private static final long serialVersionUID = 1L;
        private final int[] fieldPositions;
        private final AggregationFunction<Object>[] aggFunctions;
        private TupleSerializerBase<T> serializer;
        private TypeInformation<T> typeInfo;

        public AggregatingUdf(TypeInformation<T> typeInfo, AggregationFunction<Object>[] aggFunctions, int[] fieldPositions) {
            Preconditions.checkNotNull(typeInfo);
            Preconditions.checkNotNull(aggFunctions);
            Preconditions.checkArgument((aggFunctions.length == fieldPositions.length ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)typeInfo.isTupleType(), (Object)"TypeInfo for Scala Aggregate Operator must be a tuple TypeInfo.");
            this.typeInfo = typeInfo;
            this.aggFunctions = aggFunctions;
            this.fieldPositions = fieldPositions;
        }

        public void open(Configuration parameters) throws Exception {
            for (AggregationFunction<Object> aggFunction : this.aggFunctions) {
                aggFunction.initializeAggregate();
            }
            this.serializer = (TupleSerializerBase)this.typeInfo.createSerializer(this.getRuntimeContext().getExecutionConfig());
        }

        public void reduce(Iterable<T> records, Collector<T> out) {
            int i;
            AggregationFunction<Object>[] aggFunctions = this.aggFunctions;
            int[] fieldPositions = this.fieldPositions;
            Product current = null;
            Iterator<T> iterator = records.iterator();
            while (iterator.hasNext()) {
                Product record;
                current = record = (Product)iterator.next();
                for (i = 0; i < fieldPositions.length; ++i) {
                    Object val = current.productElement(fieldPositions[i]);
                    aggFunctions[i].aggregate(val);
                }
            }
            Object[] fields = new Object[this.serializer.getArity()];
            int length = this.serializer.getArity();
            for (i = 0; i < length; ++i) {
                fields[i] = current.productElement(i);
            }
            for (i = 0; i < fieldPositions.length; ++i) {
                Object aggVal;
                fields[fieldPositions[i]] = aggVal = aggFunctions[i].getAggregate();
                aggFunctions[i].initializeAggregate();
            }
            Product result2 = (Product)this.serializer.createInstance(fields);
            out.collect((Object)result2);
        }

        public void combine(Iterable<T> records, Collector<T> out) {
            this.reduce(records, out);
        }
    }
}

