/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.functions.SqlLikeUtils;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.LikeType;

public class ShowProceduresOperation
implements ExecutableOperation {
    @Nullable
    private final String catalogName;
    @Nullable
    private final String databaseName;
    @Nullable
    private final String preposition;
    private final boolean notLike;
    private final LikeType likeType;
    @Nullable
    private final String sqlLikePattern;

    public ShowProceduresOperation(boolean isNotLike, String likeType, String sqlLikePattern) {
        this(null, null, null, isNotLike, likeType, sqlLikePattern);
    }

    public ShowProceduresOperation(@Nullable String preposition, @Nullable String catalogName, @Nullable String databaseName, boolean notLike, @Nullable String likeType, @Nullable String sqlLikePattern) {
        this.preposition = preposition;
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        if (likeType != null) {
            this.likeType = LikeType.of(likeType);
            this.sqlLikePattern = Objects.requireNonNull(sqlLikePattern, "Like pattern must not be null");
            this.notLike = notLike;
        } else {
            this.likeType = null;
            this.sqlLikePattern = null;
            this.notLike = false;
        }
    }

    public boolean isWithLike() {
        return this.likeType != null;
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        List<String> procedures;
        CatalogManager catalogManager = ctx.getCatalogManager();
        try {
            if (this.preposition == null) {
                procedures = catalogManager.getCatalogOrError(catalogManager.getCurrentCatalog()).listProcedures(catalogManager.getCurrentDatabase());
            } else {
                Catalog catalog = catalogManager.getCatalogOrThrowException(this.catalogName);
                procedures = catalog.listProcedures(this.databaseName);
            }
        }
        catch (DatabaseNotExistException e) {
            throw new TableException(String.format("Fail to show procedures because the Database `%s` to show from/in does not exist in Catalog `%s`.", this.preposition == null ? catalogManager.getCurrentDatabase() : this.databaseName, this.preposition == null ? catalogManager.getCurrentCatalog() : this.catalogName));
        }
        String[] rows = this.isWithLike() ? (String[])procedures.stream().filter(row -> {
            boolean likeMatch = this.likeType == LikeType.ILIKE ? SqlLikeUtils.ilike(row, this.sqlLikePattern, "\\") : SqlLikeUtils.like(row, this.sqlLikePattern, "\\");
            return this.notLike != likeMatch;
        }).sorted().toArray(String[]::new) : (String[])procedures.stream().sorted().toArray(String[]::new);
        return TableResultUtils.buildStringArrayResult("procedure name", rows);
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder().append("SHOW PROCEDURES");
        if (this.preposition != null) {
            builder.append(String.format(" %s %s.%s", this.preposition, this.catalogName, this.databaseName));
        }
        if (this.isWithLike()) {
            if (this.notLike) {
                builder.append(String.format(" %s %s %s", "NOT", this.likeType.name(), this.sqlLikePattern));
            } else {
                builder.append(String.format(" %s %s", this.likeType.name(), this.sqlLikePattern));
            }
        }
        return builder.toString();
    }
}

