/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.UseOperation;

public class UseDatabaseOperation
implements UseOperation {
    private final String catalogName;
    private final String databaseName;

    public UseDatabaseOperation(String catalogName, String databaseName) {
        this.catalogName = catalogName;
        this.databaseName = databaseName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String asSummaryString() {
        return String.format("USE %s.%s", this.catalogName, this.databaseName);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ctx.getCatalogManager().setCurrentCatalog(this.catalogName);
        ctx.getCatalogManager().setCurrentDatabase(this.databaseName);
        return TableResultImpl.TABLE_RESULT_OK;
    }
}

