/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli.parser;

import java.util.List;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.SqlParserEOFException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.client.cli.CliClient;
import org.apache.flink.table.client.cli.Printer;
import org.apache.flink.table.client.cli.parser.Command;
import org.apache.flink.table.client.cli.parser.SqlClientParserState;
import org.apache.flink.table.client.cli.parser.SqlCommandParser;
import org.apache.flink.table.client.config.ResultMode;
import org.apache.flink.table.client.config.SqlClientOptions;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.StatementResult;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.impl.DefaultParser;

public class SqlMultiLineParser
extends DefaultParser {
    private static final String STATEMENT_DELIMITER = ";";
    private static final String LINE_DELIMITER = "\n";
    private static final String NEW_LINE_PROMPT = "";
    private final SqlCommandParser parser;
    private final CliClient.ExecutionMode mode;
    private final Executor executor;
    private SqlExecutionException parseException = null;
    private Printer printer;

    public SqlMultiLineParser(SqlCommandParser parser, Executor executor, CliClient.ExecutionMode mode) {
        this.parser = parser;
        this.mode = mode;
        this.executor = executor;
        this.setEscapeChars(null);
        this.setQuoteChars(null);
    }

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        if (context != Parser.ParseContext.ACCEPT_LINE) {
            return this.parseInternal(line, cursor, context);
        }
        ReadableConfig configuration = this.executor.getSessionConfig();
        String dialectName = (String)configuration.get(TableConfigOptions.TABLE_SQL_DIALECT);
        SqlDialect dialect = SqlDialect.HIVE.name().equalsIgnoreCase(dialectName) ? SqlDialect.HIVE : SqlDialect.DEFAULT;
        SqlClientParserState currentParseState = SqlClientParserState.computeCurrentStateAtTheEndOfLine(line, dialect);
        if (currentParseState != SqlClientParserState.DEFAULT || !line.trim().endsWith(STATEMENT_DELIMITER)) {
            throw new EOFError(-1, -1, "New line without EOF character.", NEW_LINE_PROMPT);
        }
        try {
            this.parseException = null;
            Command command = this.parser.parseStatement(line).orElse(null);
            if (command == null) {
                throw new EOFError(-1, -1, "New line without EOF character.", NEW_LINE_PROMPT);
            }
            switch (command) {
                case QUIT: {
                    this.printer = Printer.createQuitCommandPrinter();
                    break;
                }
                case CLEAR: {
                    this.printer = Printer.createClearCommandPrinter();
                    break;
                }
                case HELP: {
                    this.printer = Printer.createHelpCommandPrinter();
                    break;
                }
                default: {
                    if (this.mode == CliClient.ExecutionMode.INITIALIZATION) {
                        this.executor.configureSession(line);
                        this.printer = Printer.createInitializationCommandPrinter();
                        break;
                    }
                    StatementResult result = this.executor.executeStatement(line);
                    ReadableConfig sessionConfig = this.executor.getSessionConfig();
                    if (this.mode == CliClient.ExecutionMode.NON_INTERACTIVE_EXECUTION && result.isQueryResult() && sessionConfig.get(SqlClientOptions.EXECUTION_RESULT_MODE) != ResultMode.TABLEAU) {
                        throw new SqlExecutionException(String.format("In non-interactive mode, it only supports to use %s as value of %s when execute query. Please add 'SET %s=%s;' in the sql file.", new Object[]{ResultMode.TABLEAU, SqlClientOptions.EXECUTION_RESULT_MODE.key(), SqlClientOptions.EXECUTION_RESULT_MODE.key(), ResultMode.TABLEAU}));
                    }
                    this.printer = Printer.createStatementCommandPrinter(result, sessionConfig);
                    break;
                }
            }
        }
        catch (SqlExecutionException e) {
            if (e.getCause() instanceof SqlParserEOFException) {
                throw new EOFError(-1, -1, "The statement is incomplete.", NEW_LINE_PROMPT);
            }
            this.parseException = e;
            throw new SyntaxError(-1, -1, e.getMessage());
        }
        return this.parseInternal(line, cursor, context);
    }

    public static String formatSqlFile(String content) {
        String trimmed = content.trim();
        StringBuilder formatted = new StringBuilder();
        formatted.append(trimmed);
        if (!trimmed.endsWith(STATEMENT_DELIMITER)) {
            formatted.append(STATEMENT_DELIMITER);
        }
        formatted.append(LINE_DELIMITER);
        return formatted.toString();
    }

    private SqlArgumentList parseInternal(String line, int cursor, Parser.ParseContext context) {
        DefaultParser.ArgumentList parsedLine = (DefaultParser.ArgumentList)super.parse(line, cursor, context);
        return new SqlArgumentList(parsedLine.line(), parsedLine.words(), parsedLine.wordIndex(), parsedLine.wordCursor(), parsedLine.cursor(), null, parsedLine.rawWordCursor(), parsedLine.rawWordLength());
    }

    public Printer getPrinter() {
        if (this.parseException != null) {
            throw this.parseException;
        }
        return this.printer;
    }

    private class SqlArgumentList
    extends DefaultParser.ArgumentList {
        public SqlArgumentList(String line, List<String> words, int wordIndex, int wordCursor, int cursor, String openingQuote, int rawWordCursor, int rawWordLength) {
            super(SqlMultiLineParser.this, line, words, wordIndex, wordCursor, cursor, openingQuote, rawWordCursor, rawWordLength);
        }

        @Override
        public CharSequence escape(CharSequence candidate, boolean complete) {
            return candidate;
        }
    }
}

