/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Stack;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.nfa.ComputationState;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.MigrationUtils;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.nfa.SharedBuffer;
import org.apache.flink.cep.nfa.State;
import org.apache.flink.cep.nfa.StateTransition;
import org.apache.flink.cep.nfa.StateTransitionAction;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferAccessor;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.time.TimerService;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class NFA<T> {
    private final Map<String, State<T>> states;
    private final Map<String, Long> windowTimes;
    private final long windowTime;
    private final boolean handleTimeout;

    public NFA(Collection<State<T>> validStates, Map<String, Long> windowTimes, long windowTime, boolean handleTimeout) {
        this.windowTime = windowTime;
        this.handleTimeout = handleTimeout;
        this.states = this.loadStates(validStates);
        this.windowTimes = windowTimes;
    }

    private Map<String, State<T>> loadStates(Collection<State<T>> validStates) {
        HashMap tmp = CollectionUtil.newHashMapWithExpectedSize((int)4);
        for (State<T> state : validStates) {
            tmp.put(state.getName(), state);
        }
        return Collections.unmodifiableMap(tmp);
    }

    public long getWindowTime() {
        return this.windowTime;
    }

    @VisibleForTesting
    public Collection<State<T>> getStates() {
        return this.states.values();
    }

    public NFAState createInitialNFAState() {
        LinkedList<ComputationState> startingStates = new LinkedList<ComputationState>();
        for (State<T> state : this.states.values()) {
            if (!state.isStart()) continue;
            startingStates.add(ComputationState.createStartState(state.getName()));
        }
        return new NFAState(startingStates);
    }

    private State<T> getState(ComputationState state) {
        return this.states.get(state.getCurrentStateName());
    }

    private boolean isStartState(ComputationState state) {
        State<T> stateObject = this.getState(state);
        if (stateObject == null) {
            throw new FlinkRuntimeException("State " + state.getCurrentStateName() + " does not exist in the NFA. NFA has states " + this.states.values());
        }
        return stateObject.isStart();
    }

    private boolean isStopState(ComputationState state) {
        State<T> stateObject = this.getState(state);
        if (stateObject == null) {
            throw new FlinkRuntimeException("State " + state.getCurrentStateName() + " does not exist in the NFA. NFA has states " + this.states.values());
        }
        return stateObject.isStop();
    }

    private boolean isFinalState(ComputationState state) {
        State<T> stateObject = this.getState(state);
        if (stateObject == null) {
            throw new FlinkRuntimeException("State " + state.getCurrentStateName() + " does not exist in the NFA. NFA has states " + this.states.values());
        }
        return stateObject.isFinal();
    }

    public void open(RuntimeContext cepRuntimeContext, Configuration conf) throws Exception {
        for (State<T> state : this.getStates()) {
            for (StateTransition<T> transition : state.getStateTransitions()) {
                IterativeCondition<T> condition = transition.getCondition();
                FunctionUtils.setFunctionRuntimeContext(condition, (RuntimeContext)cepRuntimeContext);
                FunctionUtils.openFunction(condition, (Configuration)conf);
            }
        }
    }

    public void close() throws Exception {
        for (State<T> state : this.getStates()) {
            for (StateTransition<T> transition : state.getStateTransitions()) {
                IterativeCondition<T> condition = transition.getCondition();
                FunctionUtils.closeFunction(condition);
            }
        }
    }

    public Collection<Map<String, List<T>>> process(SharedBufferAccessor<T> sharedBufferAccessor, NFAState nfaState, T event, long timestamp, AfterMatchSkipStrategy afterMatchSkipStrategy, TimerService timerService) throws Exception {
        try (EventWrapper eventWrapper = new EventWrapper(event, timestamp, sharedBufferAccessor);){
            Collection<Map<String, List<T>>> collection = this.doProcess(sharedBufferAccessor, nfaState, eventWrapper, afterMatchSkipStrategy, timerService);
            return collection;
        }
    }

    public Tuple2<Collection<Map<String, List<T>>>, Collection<Tuple2<Map<String, List<T>>, Long>>> advanceTime(SharedBufferAccessor<T> sharedBufferAccessor, NFAState nfaState, long timestamp, AfterMatchSkipStrategy afterMatchSkipStrategy) throws Exception {
        ArrayList<Map<String, List<T>>> result = new ArrayList<Map<String, List<T>>>();
        ArrayList<Tuple2> timeoutResult = new ArrayList<Tuple2>();
        PriorityQueue<ComputationState> newPartialMatches = new PriorityQueue<ComputationState>(NFAState.COMPUTATION_STATE_COMPARATOR);
        PriorityQueue<ComputationState> potentialMatches = new PriorityQueue<ComputationState>(NFAState.COMPUTATION_STATE_COMPARATOR);
        for (ComputationState computationState : nfaState.getPartialMatches()) {
            String currentStateName = computationState.getCurrentStateName();
            boolean isTimeoutForPreviousEvent = this.windowTimes.containsKey(currentStateName) && this.isStateTimedOut(computationState, timestamp, computationState.getPreviousTimestamp(), this.windowTimes.get(currentStateName));
            boolean isTimeoutForFirstEvent = this.isStateTimedOut(computationState, timestamp, computationState.getStartTimestamp(), this.windowTime);
            if (isTimeoutForPreviousEvent || isTimeoutForFirstEvent) {
                nfaState.setStateChanged();
                if (this.getState(computationState).isPending()) {
                    potentialMatches.add(computationState);
                    continue;
                }
                if (this.handleTimeout) {
                    Map<String, List<T>> timedOutPattern = sharedBufferAccessor.materializeMatch(this.extractCurrentMatches(sharedBufferAccessor, computationState));
                    timeoutResult.add(Tuple2.of(timedOutPattern, (Object)(isTimeoutForPreviousEvent ? computationState.getPreviousTimestamp() + this.windowTimes.get(computationState.getCurrentStateName()) : computationState.getStartTimestamp() + this.windowTime)));
                }
                sharedBufferAccessor.releaseNode(computationState.getPreviousBufferEntry(), computationState.getVersion());
                continue;
            }
            newPartialMatches.add(computationState);
        }
        this.processMatchesAccordingToSkipStrategy(sharedBufferAccessor, nfaState, afterMatchSkipStrategy, potentialMatches, newPartialMatches, result);
        nfaState.setNewPartialMatches(newPartialMatches);
        sharedBufferAccessor.advanceTime(timestamp);
        return Tuple2.of(result, timeoutResult);
    }

    private boolean isStateTimedOut(ComputationState state, long timestamp, long startTimestamp, long windowTime) {
        return !this.isStartState(state) && windowTime > 0L && timestamp - startTimestamp >= windowTime;
    }

    private Collection<Map<String, List<T>>> doProcess(SharedBufferAccessor<T> sharedBufferAccessor, NFAState nfaState, EventWrapper event, AfterMatchSkipStrategy afterMatchSkipStrategy, TimerService timerService) throws Exception {
        PriorityQueue<ComputationState> newPartialMatches = new PriorityQueue<ComputationState>(NFAState.COMPUTATION_STATE_COMPARATOR);
        PriorityQueue<ComputationState> potentialMatches = new PriorityQueue<ComputationState>(NFAState.COMPUTATION_STATE_COMPARATOR);
        for (ComputationState computationState : nfaState.getPartialMatches()) {
            Collection<ComputationState> newComputationStates = this.computeNextStates(sharedBufferAccessor, computationState, event, timerService);
            if (newComputationStates.size() != 1) {
                nfaState.setStateChanged();
            } else if (!newComputationStates.iterator().next().equals(computationState)) {
                nfaState.setStateChanged();
            }
            ArrayList<ComputationState> statesToRetain = new ArrayList<ComputationState>();
            boolean shouldDiscardPath = false;
            for (ComputationState newComputationState : newComputationStates) {
                if (this.isStartState(computationState) && newComputationState.getStartTimestamp() > 0L) {
                    nfaState.setNewStartPartiailMatch();
                }
                if (this.isFinalState(newComputationState)) {
                    potentialMatches.add(newComputationState);
                    continue;
                }
                if (this.isStopState(newComputationState)) {
                    shouldDiscardPath = true;
                    sharedBufferAccessor.releaseNode(newComputationState.getPreviousBufferEntry(), newComputationState.getVersion());
                    continue;
                }
                statesToRetain.add(newComputationState);
            }
            if (shouldDiscardPath) {
                for (ComputationState state : statesToRetain) {
                    sharedBufferAccessor.releaseNode(state.getPreviousBufferEntry(), state.getVersion());
                }
                continue;
            }
            newPartialMatches.addAll(statesToRetain);
        }
        if (!potentialMatches.isEmpty()) {
            nfaState.setStateChanged();
        }
        ArrayList<Map<String, List<T>>> result = new ArrayList<Map<String, List<T>>>();
        this.processMatchesAccordingToSkipStrategy(sharedBufferAccessor, nfaState, afterMatchSkipStrategy, potentialMatches, newPartialMatches, result);
        nfaState.setNewPartialMatches(newPartialMatches);
        return result;
    }

    private void processMatchesAccordingToSkipStrategy(SharedBufferAccessor<T> sharedBufferAccessor, NFAState nfaState, AfterMatchSkipStrategy afterMatchSkipStrategy, PriorityQueue<ComputationState> potentialMatches, PriorityQueue<ComputationState> partialMatches, List<Map<String, List<T>>> result) throws Exception {
        ComputationState earliestPartialMatch;
        ComputationState earliestMatch;
        nfaState.getCompletedMatches().addAll(potentialMatches);
        while ((earliestMatch = nfaState.getCompletedMatches().peek()) != null && (!afterMatchSkipStrategy.isSkipStrategy() || (earliestPartialMatch = partialMatches.peek()) == null || this.isEarlier(earliestMatch, earliestPartialMatch))) {
            nfaState.setStateChanged();
            nfaState.getCompletedMatches().poll();
            List<Map<String, List<EventId>>> matchedResult = sharedBufferAccessor.extractPatterns(earliestMatch.getPreviousBufferEntry(), earliestMatch.getVersion());
            afterMatchSkipStrategy.prune(partialMatches, matchedResult, sharedBufferAccessor);
            afterMatchSkipStrategy.prune(nfaState.getCompletedMatches(), matchedResult, sharedBufferAccessor);
            result.add(sharedBufferAccessor.materializeMatch(matchedResult.get(0)));
            sharedBufferAccessor.releaseNode(earliestMatch.getPreviousBufferEntry(), earliestMatch.getVersion());
        }
        nfaState.getPartialMatches().removeIf(pm -> pm.getStartEventID() != null && !partialMatches.contains(pm));
    }

    private boolean isEarlier(ComputationState earliestMatch, ComputationState earliestPartialMatch) {
        return NFAState.COMPUTATION_STATE_COMPARATOR.compare(earliestMatch, earliestPartialMatch) <= 0;
    }

    private static <T> boolean isEquivalentState(State<T> s1, State<T> s2) {
        return s1.getName().equals(s2.getName());
    }

    private Collection<ComputationState> computeNextStates(SharedBufferAccessor<T> sharedBufferAccessor, ComputationState computationState, EventWrapper event, TimerService timerService) throws Exception {
        ConditionContext context = new ConditionContext(sharedBufferAccessor, computationState, timerService, event.getTimestamp());
        OutgoingEdges outgoingEdges = this.createDecisionGraph(context, computationState, event.getEvent());
        List edges = outgoingEdges.getEdges();
        int takeBranchesToVisit = Math.max(0, outgoingEdges.getTotalTakeBranches() - 1);
        int ignoreBranchesToVisit = outgoingEdges.getTotalIgnoreBranches();
        int totalTakeToSkip = Math.max(0, outgoingEdges.getTotalTakeBranches() - 1);
        ArrayList<ComputationState> resultingComputationStates = new ArrayList<ComputationState>();
        for (StateTransition edge : edges) {
            switch (edge.getAction()) {
                case IGNORE: {
                    DeweyNumber version;
                    if (this.isStartState(computationState)) break;
                    if (NFA.isEquivalentState(edge.getTargetState(), this.getState(computationState))) {
                        int toIncrease = this.calculateIncreasingSelfState(outgoingEdges.getTotalIgnoreBranches(), outgoingEdges.getTotalTakeBranches());
                        version = computationState.getVersion().increase(toIncrease);
                    } else {
                        version = computationState.getVersion().increase(totalTakeToSkip + ignoreBranchesToVisit).addStage();
                        --ignoreBranchesToVisit;
                    }
                    this.addComputationState(sharedBufferAccessor, resultingComputationStates, edge.getTargetState(), computationState.getPreviousBufferEntry(), version, computationState.getStartTimestamp(), computationState.getPreviousTimestamp(), computationState.getStartEventID());
                    break;
                }
                case TAKE: {
                    EventId startEventId;
                    long startTimestamp;
                    State nextState = edge.getTargetState();
                    State currentState = edge.getSourceState();
                    NodeId previousEntry = computationState.getPreviousBufferEntry();
                    DeweyNumber currentVersion = computationState.getVersion().increase(takeBranchesToVisit);
                    DeweyNumber nextVersion = new DeweyNumber(currentVersion).addStage();
                    --takeBranchesToVisit;
                    NodeId newEntry = sharedBufferAccessor.put(currentState.getName(), event.getEventId(), previousEntry, currentVersion);
                    if (this.isStartState(computationState)) {
                        startTimestamp = event.getTimestamp();
                        startEventId = event.getEventId();
                    } else {
                        startTimestamp = computationState.getStartTimestamp();
                        startEventId = computationState.getStartEventID();
                    }
                    long previousTimestamp = event.getTimestamp();
                    this.addComputationState(sharedBufferAccessor, resultingComputationStates, nextState, newEntry, nextVersion, startTimestamp, previousTimestamp, startEventId);
                    State finalState = this.findFinalStateAfterProceed(context, nextState, event.getEvent());
                    if (finalState == null) break;
                    this.addComputationState(sharedBufferAccessor, resultingComputationStates, finalState, newEntry, nextVersion, startTimestamp, previousTimestamp, startEventId);
                }
            }
        }
        if (this.isStartState(computationState)) {
            int totalBranches = this.calculateIncreasingSelfState(outgoingEdges.getTotalIgnoreBranches(), outgoingEdges.getTotalTakeBranches());
            DeweyNumber startVersion = computationState.getVersion().increase(totalBranches);
            ComputationState startState = ComputationState.createStartState(computationState.getCurrentStateName(), startVersion);
            resultingComputationStates.add(startState);
        }
        if (computationState.getPreviousBufferEntry() != null) {
            sharedBufferAccessor.releaseNode(computationState.getPreviousBufferEntry(), computationState.getVersion());
        }
        return resultingComputationStates;
    }

    private void addComputationState(SharedBufferAccessor<T> sharedBufferAccessor, List<ComputationState> computationStates, State<T> currentState, NodeId previousEntry, DeweyNumber version, long startTimestamp, long previousTimestamp, EventId startEventId) throws Exception {
        ComputationState computationState = ComputationState.createState(currentState.getName(), previousEntry, version, startTimestamp, previousTimestamp, startEventId);
        computationStates.add(computationState);
        sharedBufferAccessor.lockNode(previousEntry, computationState.getVersion());
    }

    private State<T> findFinalStateAfterProceed(ConditionContext context, State<T> state, T event) {
        Stack statesToCheck = new Stack();
        statesToCheck.push(state);
        try {
            while (!statesToCheck.isEmpty()) {
                State currentState = (State)statesToCheck.pop();
                for (StateTransition transition : currentState.getStateTransitions()) {
                    if (transition.getAction() != StateTransitionAction.PROCEED || !this.checkFilterCondition(context, transition.getCondition(), event)) continue;
                    if (transition.getTargetState().isFinal()) {
                        return transition.getTargetState();
                    }
                    statesToCheck.push(transition.getTargetState());
                }
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failure happened in filter function.", (Throwable)e);
        }
        return null;
    }

    private int calculateIncreasingSelfState(int ignoreBranches, int takeBranches) {
        return takeBranches == 0 && ignoreBranches == 0 ? 0 : ignoreBranches + Math.max(1, takeBranches);
    }

    private OutgoingEdges<T> createDecisionGraph(ConditionContext context, ComputationState computationState, T event) {
        State<T> state = this.getState(computationState);
        OutgoingEdges outgoingEdges = new OutgoingEdges(state);
        Stack states = new Stack();
        states.push(state);
        while (!states.isEmpty()) {
            State currentState = (State)states.pop();
            Collection stateTransitions = currentState.getStateTransitions();
            for (StateTransition stateTransition : stateTransitions) {
                try {
                    if (!this.checkFilterCondition(context, stateTransition.getCondition(), event)) continue;
                    switch (stateTransition.getAction()) {
                        case PROCEED: {
                            states.push(stateTransition.getTargetState());
                            break;
                        }
                        case IGNORE: 
                        case TAKE: {
                            outgoingEdges.add(stateTransition);
                        }
                    }
                }
                catch (Exception e) {
                    throw new FlinkRuntimeException("Failure happened in filter function.", (Throwable)e);
                }
            }
        }
        return outgoingEdges;
    }

    private boolean checkFilterCondition(ConditionContext context, IterativeCondition<T> condition, T event) throws Exception {
        return condition == null || condition.filter(event, context);
    }

    private Map<String, List<EventId>> extractCurrentMatches(SharedBufferAccessor<T> sharedBufferAccessor, ComputationState computationState) throws Exception {
        if (computationState.getPreviousBufferEntry() == null) {
            return new HashMap<String, List<EventId>>();
        }
        List<Map<String, List<EventId>>> paths = sharedBufferAccessor.extractPatterns(computationState.getPreviousBufferEntry(), computationState.getVersion());
        if (paths.isEmpty()) {
            return new HashMap<String, List<EventId>>();
        }
        Preconditions.checkState((paths.size() == 1 ? 1 : 0) != 0);
        return paths.get(0);
    }

    @Deprecated
    public static class NFASerializer<T>
    extends TypeSerializer<MigratedNFA<T>> {
        private static final long serialVersionUID = 2098282423980597010L;
        private final TypeSerializer<SharedBuffer<T>> sharedBufferSerializer;
        private final TypeSerializer<T> eventSerializer;

        public NFASerializer(TypeSerializer<T> typeSerializer) {
            this(typeSerializer, new SharedBuffer.SharedBufferSerializer(StringSerializer.INSTANCE, typeSerializer));
        }

        NFASerializer(TypeSerializer<T> typeSerializer, TypeSerializer<SharedBuffer<T>> sharedBufferSerializer) {
            this.eventSerializer = typeSerializer;
            this.sharedBufferSerializer = sharedBufferSerializer;
        }

        public boolean isImmutableType() {
            return false;
        }

        public NFASerializer<T> duplicate() {
            return new NFASerializer<T>(this.eventSerializer.duplicate());
        }

        public MigratedNFA<T> createInstance() {
            return null;
        }

        public MigratedNFA<T> copy(MigratedNFA<T> from) {
            throw new UnsupportedOperationException();
        }

        public MigratedNFA<T> copy(MigratedNFA<T> from, MigratedNFA<T> reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(MigratedNFA<T> record, DataOutputView target) {
            throw new UnsupportedOperationException();
        }

        public MigratedNFA<T> deserialize(DataInputView source) throws IOException {
            MigrationUtils.skipSerializedStates(source);
            source.readLong();
            source.readBoolean();
            SharedBuffer sharedBuffer = (SharedBuffer)this.sharedBufferSerializer.deserialize(source);
            Queue<ComputationState> computationStates = MigrationUtils.deserializeComputationStates(sharedBuffer, this.eventSerializer, source);
            return new MigratedNFA(computationStates, sharedBuffer);
        }

        public MigratedNFA<T> deserialize(MigratedNFA<T> reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(((Object)((Object)this)).getClass()) && this.sharedBufferSerializer.equals(((NFASerializer)((Object)obj)).sharedBufferSerializer) && this.eventSerializer.equals(((NFASerializer)((Object)obj)).eventSerializer);
        }

        public int hashCode() {
            return 37 * this.sharedBufferSerializer.hashCode() + this.eventSerializer.hashCode();
        }

        public MigratedNFASerializerSnapshot<T> snapshotConfiguration() {
            return new MigratedNFASerializerSnapshot(this);
        }
    }

    public static final class MigratedNFASerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<MigratedNFA<T>, NFASerializer<T>> {
        private static final int VERSION = 2;

        public MigratedNFASerializerSnapshot() {
            super(NFASerializer.class);
        }

        MigratedNFASerializerSnapshot(NFASerializer<T> legacyNfaSerializer) {
            super(legacyNfaSerializer);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 2;
        }

        protected TypeSerializer<?>[] getNestedSerializers(NFASerializer<T> outerSerializer) {
            return new TypeSerializer[]{((NFASerializer)outerSerializer).eventSerializer, ((NFASerializer)outerSerializer).sharedBufferSerializer};
        }

        protected NFASerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> eventSerializer = nestedSerializers[0];
            TypeSerializer<?> sharedBufferSerializer = nestedSerializers[1];
            return new NFASerializer(eventSerializer, sharedBufferSerializer);
        }
    }

    public static class MigratedNFA<T> {
        private final Queue<ComputationState> computationStates;
        private final SharedBuffer<T> sharedBuffer;

        public SharedBuffer<T> getSharedBuffer() {
            return this.sharedBuffer;
        }

        public Queue<ComputationState> getComputationStates() {
            return this.computationStates;
        }

        MigratedNFA(Queue<ComputationState> computationStates, SharedBuffer<T> sharedBuffer) {
            this.sharedBuffer = sharedBuffer;
            this.computationStates = computationStates;
        }
    }

    private class ConditionContext
    implements IterativeCondition.Context<T> {
        private final TimerService timerService;
        private final long eventTimestamp;
        private ComputationState computationState;
        private Map<String, List<T>> matchedEvents;
        private SharedBufferAccessor<T> sharedBufferAccessor;

        ConditionContext(SharedBufferAccessor<T> sharedBufferAccessor, ComputationState computationState, TimerService timerService, long eventTimestamp) {
            this.computationState = computationState;
            this.sharedBufferAccessor = sharedBufferAccessor;
            this.timerService = timerService;
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public Iterable<T> getEventsForPattern(final String key) throws Exception {
            Preconditions.checkNotNull((Object)key);
            if (this.matchedEvents == null) {
                this.matchedEvents = this.sharedBufferAccessor.materializeMatch(NFA.this.extractCurrentMatches(this.sharedBufferAccessor, this.computationState));
            }
            return new Iterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    List elements = (List)ConditionContext.this.matchedEvents.get(key);
                    return elements == null ? Collections.EMPTY_LIST.iterator() : elements.iterator();
                }
            };
        }

        @Override
        public long timestamp() {
            return this.eventTimestamp;
        }

        @Override
        public long currentProcessingTime() {
            return this.timerService.currentProcessingTime();
        }
    }

    private class EventWrapper
    implements AutoCloseable {
        private final T event;
        private long timestamp;
        private final SharedBufferAccessor<T> sharedBufferAccessor;
        private EventId eventId;

        EventWrapper(T event, long timestamp, SharedBufferAccessor<T> sharedBufferAccessor) {
            this.event = event;
            this.timestamp = timestamp;
            this.sharedBufferAccessor = sharedBufferAccessor;
        }

        EventId getEventId() throws Exception {
            if (this.eventId == null) {
                this.eventId = this.sharedBufferAccessor.registerEvent(this.event, this.timestamp);
            }
            return this.eventId;
        }

        T getEvent() {
            return this.event;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public void close() throws Exception {
            if (this.eventId != null) {
                this.sharedBufferAccessor.releaseEvent(this.eventId);
            }
        }
    }

    private static class OutgoingEdges<T> {
        private List<StateTransition<T>> edges = new ArrayList<StateTransition<T>>();
        private final State<T> currentState;
        private int totalTakeBranches = 0;
        private int totalIgnoreBranches = 0;

        OutgoingEdges(State<T> currentState) {
            this.currentState = currentState;
        }

        void add(StateTransition<T> edge) {
            if (!this.isSelfIgnore(edge)) {
                if (edge.getAction() == StateTransitionAction.IGNORE) {
                    ++this.totalIgnoreBranches;
                } else if (edge.getAction() == StateTransitionAction.TAKE) {
                    ++this.totalTakeBranches;
                }
            }
            this.edges.add(edge);
        }

        int getTotalIgnoreBranches() {
            return this.totalIgnoreBranches;
        }

        int getTotalTakeBranches() {
            return this.totalTakeBranches;
        }

        List<StateTransition<T>> getEdges() {
            return this.edges;
        }

        private boolean isSelfIgnore(StateTransition<T> edge) {
            return NFA.isEquivalentState(edge.getTargetState(), this.currentState) && edge.getAction() == StateTransitionAction.IGNORE;
        }
    }
}

