/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.compression.BlockCompressor;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionUtils;

public class CompressedBlockChannelWriter
implements BlockChannelWriter<MemorySegment>,
BufferRecycler {
    private final LinkedBlockingQueue<MemorySegment> blockQueue;
    private final LinkedBlockingQueue<MemorySegment> compressedBuffers = new LinkedBlockingQueue();
    private final BufferFileWriter writer;
    private final boolean copyCompress;
    private final BlockCompressor compressor;
    private byte[] buf;
    private ByteBuffer bufWrapper;
    private int count;

    public CompressedBlockChannelWriter(IOManager ioManager, FileIOChannel.ID channel, LinkedBlockingQueue<MemorySegment> blockQueue, BlockCompressionFactory codecFactory, int preferBlockSize, int segmentSize) throws IOException {
        this.writer = ioManager.createBufferFileWriter(channel);
        this.blockQueue = blockQueue;
        this.copyCompress = preferBlockSize > segmentSize * 2;
        int blockSize = this.copyCompress ? preferBlockSize : segmentSize;
        this.compressor = codecFactory.getCompressor();
        if (this.copyCompress) {
            this.buf = new byte[blockSize];
            this.bufWrapper = ByteBuffer.wrap(this.buf);
        }
        for (int i = 0; i < 2; ++i) {
            this.compressedBuffers.add(MemorySegmentFactory.wrap((byte[])new byte[this.compressor.getMaxCompressedSize(blockSize)]));
        }
    }

    public void writeBlock(MemorySegment block) throws IOException {
        if (this.copyCompress) {
            int offset = 0;
            int len = block.size();
            while (len > 0) {
                int copy = Math.min(len, this.buf.length - this.count);
                if (copy == 0) {
                    this.flushBuffer();
                    continue;
                }
                block.get(offset, this.buf, this.count, copy);
                this.count += copy;
                offset += copy;
                len -= copy;
            }
        } else {
            block.processAsByteBuffer(FunctionUtils.uncheckedConsumer(buffer -> this.compressBuffer((ByteBuffer)buffer, block.size())));
        }
        boolean add = this.blockQueue.add(block);
        Preconditions.checkState((boolean)add);
    }

    private void flushBuffer() throws IOException {
        this.compressBuffer(this.bufWrapper, this.count);
        this.count = 0;
    }

    private void compressBuffer(ByteBuffer buffer, int len) throws IOException {
        MemorySegment compressedBuffer;
        try {
            compressedBuffer = this.compressedBuffers.take();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        int compressedLen = (Integer)compressedBuffer.processAsByteBuffer(dstBuffer -> this.compressor.compress(buffer, 0, len, dstBuffer, 0));
        NetworkBuffer networkBuffer = new NetworkBuffer(compressedBuffer, (BufferRecycler)this);
        networkBuffer.setSize(compressedLen);
        this.writer.writeBlock((Object)networkBuffer);
    }

    public FileIOChannel.ID getChannelID() {
        return this.writer.getChannelID();
    }

    public long getSize() throws IOException {
        return this.writer.getSize();
    }

    public boolean isClosed() {
        return this.writer.isClosed();
    }

    public void close() throws IOException {
        if (!this.writer.isClosed()) {
            if (this.copyCompress) {
                this.flushBuffer();
            }
            this.writer.close();
        }
    }

    public void deleteChannel() {
        this.writer.deleteChannel();
    }

    public void closeAndDelete() throws IOException {
        this.writer.closeAndDelete();
    }

    public FileChannel getNioFileChannel() {
        return this.writer.getNioFileChannel();
    }

    public void recycle(MemorySegment memorySegment) {
        this.compressedBuffers.add(memorySegment);
    }

    public MemorySegment getNextReturnedBlock() throws IOException {
        try {
            do {
                MemorySegment next;
                if ((next = this.blockQueue.poll(1000L, TimeUnit.MILLISECONDS)) == null) continue;
                return next;
            } while (!this.writer.isClosed());
            throw new IOException("The writer has been closed.");
        }
        catch (InterruptedException e) {
            throw new IOException("Writer was interrupted while waiting for the next returning segment.");
        }
    }

    public LinkedBlockingQueue<MemorySegment> getReturnQueue() {
        return this.blockQueue;
    }
}

