/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.flink.streaming.api.functions.co.KeyedCoProcessFunction;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.co.KeyedCoProcessOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.util.Preconditions;

public class KeyedCoProcessOperatorWithWatermarkDelay<K, IN1, IN2, OUT>
extends KeyedCoProcessOperator<K, IN1, IN2, OUT> {
    private static final long serialVersionUID = -7435774708099223442L;
    private final Consumer<Watermark> emitter;

    public KeyedCoProcessOperatorWithWatermarkDelay(KeyedCoProcessFunction<K, IN1, IN2, OUT> flatMapper, long watermarkDelay) {
        super(flatMapper);
        Preconditions.checkArgument((watermarkDelay >= 0L ? 1 : 0) != 0, (Object)"The watermark delay should be non-negative.");
        this.emitter = watermarkDelay == 0L ? (Consumer<Watermark> & Serializable)mark -> this.output.emitWatermark(mark) : (Consumer<Watermark> & Serializable)mark -> this.output.emitWatermark(new Watermark(mark.getTimestamp() - watermarkDelay));
    }

    public void processWatermark(Watermark mark) throws Exception {
        Optional timeServiceManager = this.getTimeServiceManager();
        if (timeServiceManager.isPresent()) {
            ((InternalTimeServiceManager)timeServiceManager.get()).advanceWatermark(mark);
        }
        this.emitter.accept(mark);
    }
}

