/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.externalresource.gpu;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.externalresource.ExternalResourceDriver;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.externalresource.gpu.GPUInfo;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GPUDriver
implements ExternalResourceDriver {
    private static final Logger LOG = LoggerFactory.getLogger(GPUDriver.class);
    private static final long DISCOVERY_SCRIPT_TIMEOUT_MS = 10000L;
    @VisibleForTesting
    static final ConfigOption<String> DISCOVERY_SCRIPT_PATH = ConfigOptions.key((String)"discovery-script.path").stringType().defaultValue((Object)String.format("%s/external-resource-gpu/nvidia-gpu-discovery.sh", "plugins"));
    @VisibleForTesting
    static final ConfigOption<String> DISCOVERY_SCRIPT_ARG = ConfigOptions.key((String)"discovery-script.args").stringType().noDefaultValue();
    private final File discoveryScriptFile;
    private final String args;

    GPUDriver(Configuration config) throws Exception {
        String discoveryScriptPathStr = config.getString(DISCOVERY_SCRIPT_PATH);
        if (StringUtils.isNullOrWhitespaceOnly((String)discoveryScriptPathStr)) {
            throw new IllegalConfigurationException(String.format("GPU discovery script ('%s') is not configured.", ExternalResourceOptions.genericKeyWithSuffix((String)DISCOVERY_SCRIPT_PATH.key())));
        }
        Path discoveryScriptPath = Paths.get(discoveryScriptPathStr, new String[0]);
        if (!discoveryScriptPath.isAbsolute()) {
            discoveryScriptPath = Paths.get(System.getenv().getOrDefault("FLINK_HOME", "."), discoveryScriptPathStr);
        }
        this.discoveryScriptFile = discoveryScriptPath.toFile();
        if (!this.discoveryScriptFile.exists()) {
            throw new FileNotFoundException(String.format("The gpu discovery script does not exist in path %s.", this.discoveryScriptFile.getAbsolutePath()));
        }
        if (!this.discoveryScriptFile.canExecute()) {
            throw new FlinkException(String.format("The discovery script %s is not executable.", this.discoveryScriptFile.getAbsolutePath()));
        }
        this.args = config.getString(DISCOVERY_SCRIPT_ARG);
    }

    public Set<GPUInfo> retrieveResourceInfo(long gpuAmount) throws Exception {
        Preconditions.checkArgument((gpuAmount > 0L ? 1 : 0) != 0, (Object)"The gpuAmount should be positive when retrieving the GPU resource information.");
        HashSet<GPUInfo> gpuResources = new HashSet<GPUInfo>();
        String output = this.executeDiscoveryScript(this.discoveryScriptFile, gpuAmount, this.args);
        if (!output.isEmpty()) {
            String[] indexes;
            for (String index : indexes = output.split(",")) {
                if (StringUtils.isNullOrWhitespaceOnly((String)index)) continue;
                gpuResources.add(new GPUInfo(index.trim()));
            }
        }
        LOG.info("Discover GPU resources: {}.", gpuResources);
        return Collections.unmodifiableSet(gpuResources);
    }

    /*
     * Exception decompiling
     */
    private String executeDiscoveryScript(File discoveryScript, long gpuAmount, String args) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

