/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.client.cli.parser.SyntaxHighlightStyle;
import org.jline.utils.AttributedStringBuilder;

public enum SqlClientParserState {
    QUOTED("'", "'", dialect -> true, (asb, style) -> asb.style(style.getQuotedStyle())),
    SQL_QUOTED_IDENTIFIER("`", "`", dialect -> dialect == SqlDialect.DEFAULT || dialect == null, (asb, style) -> asb.style(style.getSqlIdentifierStyle())),
    HIVE_SQL_QUOTED_IDENTIFIER("\"", "\"", dialect -> dialect == SqlDialect.HIVE, (asb, style) -> asb.style(style.getSqlIdentifierStyle())),
    ONE_LINE_COMMENTED("--", "\n", dialect -> true, (asb, style) -> asb.style(style.getCommentStyle())),
    HINTED("/*+", "*/", dialect -> true, (asb, style) -> asb.style(style.getHintStyle())),
    MULTILINE_COMMENTED("/*", "*/", dialect -> true, (asb, style) -> asb.style(style.getCommentStyle())),
    DEFAULT(null, null, dialect -> true, (asb, style) -> asb.style(style.getDefaultStyle()));

    private final String start;
    private final String end;
    private final Function<SqlDialect, Boolean> condition;
    private final BiConsumer<AttributedStringBuilder, SyntaxHighlightStyle> styleSetter;
    private static final List<SqlClientParserState> STATE_LIST_WITHOUT_DEFAULT;
    private static final Set<Character> STATE_START_SYMBOLS;

    private SqlClientParserState(String start, String end, Function<SqlDialect, Boolean> condition, BiConsumer<AttributedStringBuilder, SyntaxHighlightStyle> styleSetter) {
        this.start = start;
        this.end = end;
        this.condition = condition;
        this.styleSetter = styleSetter;
    }

    static SqlClientParserState computeStateAt(String input, int pos, SqlDialect dialect) {
        char currentChar = input.charAt(pos);
        if (!STATE_START_SYMBOLS.contains(Character.valueOf(currentChar))) {
            return DEFAULT;
        }
        for (SqlClientParserState state : STATE_LIST_WITHOUT_DEFAULT) {
            if (!state.condition.apply(dialect).booleanValue() || !state.start.regionMatches(0, input, pos, state.start.length())) continue;
            return state;
        }
        return DEFAULT;
    }

    public static SqlClientParserState computeCurrentStateAtTheEndOfLine(String line, SqlDialect dialect) {
        SqlClientParserState prevParseState = DEFAULT;
        SqlClientParserState currentParseState = DEFAULT;
        for (int i = 0; i < line.length(); ++i) {
            if (prevParseState == DEFAULT) {
                currentParseState = SqlClientParserState.computeStateAt(line, i, dialect);
                if (currentParseState != DEFAULT) {
                    i += currentParseState.getStart().length() - 1;
                }
            } else if (currentParseState.isEndMarkerOfState(line, i)) {
                currentParseState = DEFAULT;
            }
            prevParseState = currentParseState;
        }
        return currentParseState;
    }

    boolean isEndMarkerOfState(String input, int pos) {
        if (this.end == null) {
            return false;
        }
        return this.end.length() > 0 && input.regionMatches(pos, this.end, 0, this.end.length());
    }

    public BiConsumer<AttributedStringBuilder, SyntaxHighlightStyle> getStyleSetter() {
        return this.styleSetter;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    static {
        STATE_LIST_WITHOUT_DEFAULT = Arrays.stream(SqlClientParserState.values()).filter(t -> t != DEFAULT).collect(Collectors.toList());
        STATE_START_SYMBOLS = Arrays.stream(SqlClientParserState.values()).filter(t -> t != DEFAULT).map(t -> Character.valueOf(t.start.charAt(0))).collect(Collectors.toSet());
    }
}

