/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.StatefulSinkWriter;
import org.apache.flink.api.connector.sink2.WriterInitContext;
import org.apache.flink.connector.base.sink.writer.Batch;
import org.apache.flink.connector.base.sink.writer.BatchCreator;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.DequeRequestBuffer;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.base.sink.writer.RequestBuffer;
import org.apache.flink.connector.base.sink.writer.RequestEntryWrapper;
import org.apache.flink.connector.base.sink.writer.ResultHandler;
import org.apache.flink.connector.base.sink.writer.SimpleBatchCreator;
import org.apache.flink.connector.base.sink.writer.config.AsyncSinkWriterConfiguration;
import org.apache.flink.connector.base.sink.writer.strategy.BasicRequestInfo;
import org.apache.flink.connector.base.sink.writer.strategy.BasicResultInfo;
import org.apache.flink.connector.base.sink.writer.strategy.RateLimitingStrategy;
import org.apache.flink.connector.base.sink.writer.strategy.RequestInfo;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.groups.SinkWriterMetricGroup;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class AsyncSinkWriter<InputT, RequestEntryT extends Serializable>
implements StatefulSinkWriter<InputT, BufferedRequestState<RequestEntryT>> {
    private final MailboxExecutor mailboxExecutor;
    private final ProcessingTimeService timeService;
    private long lastSendTimestamp = 0L;
    private long ackTime = Long.MAX_VALUE;
    private final SinkWriterMetricGroup metrics;
    private final Counter numBytesOutCounter;
    private final Counter numRecordsOutCounter;
    private final RateLimitingStrategy rateLimitingStrategy;
    private final int maxBatchSize;
    private final int maxBufferedRequests;
    private final long flushThresholdBytes;
    private final long maxTimeInBufferMS;
    private final long maxRecordSizeInBytes;
    private final long requestTimeoutMS;
    private final boolean failOnTimeout;
    private final ElementConverter<InputT, RequestEntryT> elementConverter;
    private final RequestBuffer<RequestEntryT> bufferedRequestEntries;
    private final BatchCreator<RequestEntryT> batchCreator;
    private int inFlightRequestsCount;
    private boolean existsActiveTimerCallback = false;
    private final Consumer<Exception> fatalExceptionCons;

    protected void submitRequestEntries(List<RequestEntryT> requestEntries, ResultHandler<RequestEntryT> resultHandler) {
        throw new UnsupportedOperationException("Please override the method.");
    }

    protected abstract long getSizeInBytes(RequestEntryT var1);

    @Deprecated
    public AsyncSinkWriter(ElementConverter<InputT, RequestEntryT> elementConverter, WriterInitContext context, AsyncSinkWriterConfiguration configuration, Collection<BufferedRequestState<RequestEntryT>> states) {
        this(elementConverter, context, configuration, states, new SimpleBatchCreator(configuration.getMaxBatchSizeInBytes()), new DequeRequestBuffer());
    }

    public AsyncSinkWriter(ElementConverter<InputT, RequestEntryT> elementConverter, WriterInitContext context, AsyncSinkWriterConfiguration configuration, Collection<BufferedRequestState<RequestEntryT>> states, BatchCreator<RequestEntryT> batchCreator, RequestBuffer<RequestEntryT> bufferedRequestEntries) {
        this.elementConverter = elementConverter;
        this.mailboxExecutor = context.getMailboxExecutor();
        this.timeService = context.getProcessingTimeService();
        Preconditions.checkNotNull(elementConverter);
        Preconditions.checkArgument((configuration.getMaxBatchSize() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((configuration.getMaxBufferedRequests() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((configuration.getMaxBatchSizeInBytes() > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((configuration.getMaxTimeInBufferMS() > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((configuration.getMaxRecordSizeInBytes() > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((configuration.getMaxBufferedRequests() > configuration.getMaxBatchSize() ? 1 : 0) != 0, (Object)"The maximum number of requests that may be buffered should be strictly greater than the maximum number of requests per batch.");
        Preconditions.checkArgument((configuration.getMaxBatchSizeInBytes() >= configuration.getMaxRecordSizeInBytes() ? 1 : 0) != 0, (Object)"The maximum allowed size in bytes per flush must be greater than or equal to the maximum allowed size in bytes of a single record.");
        Preconditions.checkNotNull((Object)configuration.getRateLimitingStrategy());
        Preconditions.checkNotNull(batchCreator, (String)"batchCreator must not be null; required for creating batches.");
        Preconditions.checkNotNull(bufferedRequestEntries, (String)"bufferedRequestEntries must not be null; holds pending request data.");
        this.maxBatchSize = configuration.getMaxBatchSize();
        this.maxBufferedRequests = configuration.getMaxBufferedRequests();
        this.flushThresholdBytes = configuration.getMaxBatchSizeInBytes();
        this.maxTimeInBufferMS = configuration.getMaxTimeInBufferMS();
        this.maxRecordSizeInBytes = configuration.getMaxRecordSizeInBytes();
        this.rateLimitingStrategy = configuration.getRateLimitingStrategy();
        this.requestTimeoutMS = configuration.getRequestTimeoutMS();
        this.failOnTimeout = configuration.isFailOnTimeout();
        this.inFlightRequestsCount = 0;
        this.metrics = context.metricGroup();
        this.metrics.setCurrentSendTimeGauge(() -> this.ackTime - this.lastSendTimestamp);
        this.numBytesOutCounter = this.metrics.getIOMetricGroup().getNumBytesOutCounter();
        this.numRecordsOutCounter = this.metrics.getIOMetricGroup().getNumRecordsOutCounter();
        this.batchCreator = batchCreator;
        this.bufferedRequestEntries = bufferedRequestEntries;
        this.fatalExceptionCons = exception -> this.mailboxExecutor.execute(() -> {
            throw exception;
        }, "A fatal exception occurred in the sink that cannot be recovered from or should not be retried.");
        elementConverter.open(context);
        this.initializeState(states);
    }

    private void registerCallback() {
        ProcessingTimeService.ProcessingTimeCallback ptc = instant -> {
            this.existsActiveTimerCallback = false;
            while (!this.bufferedRequestEntries.isEmpty()) {
                this.flush();
            }
        };
        this.timeService.registerTimer(this.timeService.getCurrentProcessingTime() + this.maxTimeInBufferMS, ptc);
        this.existsActiveTimerCallback = true;
    }

    public void write(InputT element, SinkWriter.Context context) throws IOException, InterruptedException {
        while (this.bufferedRequestEntries.size() >= this.maxBufferedRequests) {
            this.flush();
        }
        this.addEntryToBuffer((Serializable)this.elementConverter.apply(element, context), false);
        this.nonBlockingFlush();
    }

    private void nonBlockingFlush() throws InterruptedException {
        while (!(this.rateLimitingStrategy.shouldBlock(this.createRequestInfo()) || this.bufferedRequestEntries.size() < this.getNextBatchSizeLimit() && this.bufferedRequestEntries.totalSizeInBytes() < this.flushThresholdBytes)) {
            this.flush();
        }
    }

    private BasicRequestInfo createRequestInfo() {
        int batchSize = this.getNextBatchSize();
        return new BasicRequestInfo(batchSize);
    }

    private void flush() throws InterruptedException {
        BasicRequestInfo requestInfo = this.createRequestInfo();
        while (this.rateLimitingStrategy.shouldBlock(requestInfo)) {
            this.mailboxExecutor.yield();
            requestInfo = this.createRequestInfo();
        }
        Batch<RequestEntryT> batchCreationResult = this.batchCreator.createNextBatch(requestInfo, this.bufferedRequestEntries);
        List<RequestEntryT> batch = batchCreationResult.getBatchEntries();
        this.numBytesOutCounter.inc(batchCreationResult.getSizeInBytes());
        this.numRecordsOutCounter.inc((long)batchCreationResult.getRecordCount());
        if (batch.isEmpty()) {
            return;
        }
        long requestTimestamp = System.currentTimeMillis();
        this.rateLimitingStrategy.registerInFlightRequest(requestInfo);
        ++this.inFlightRequestsCount;
        this.submitRequestEntries(batch, new AsyncSinkWriterResultHandler(requestTimestamp, batch, requestInfo));
    }

    private int getNextBatchSize() {
        return Math.min(this.getNextBatchSizeLimit(), this.bufferedRequestEntries.size());
    }

    private void completeRequest(List<RequestEntryT> failedRequestEntries, int batchSize, long requestStartTime) throws InterruptedException {
        this.lastSendTimestamp = requestStartTime;
        this.ackTime = System.currentTimeMillis();
        --this.inFlightRequestsCount;
        this.rateLimitingStrategy.registerCompletedRequest(new BasicResultInfo(failedRequestEntries.size(), batchSize));
        ListIterator<RequestEntryT> iterator = failedRequestEntries.listIterator(failedRequestEntries.size());
        while (iterator.hasPrevious()) {
            this.addEntryToBuffer((Serializable)iterator.previous(), true);
        }
        this.nonBlockingFlush();
    }

    private void addEntryToBuffer(RequestEntryT entry, boolean insertAtHead) {
        this.addEntryToBuffer(new RequestEntryWrapper<RequestEntryT>(entry, this.getSizeInBytes(entry)), insertAtHead);
    }

    private void addEntryToBuffer(RequestEntryWrapper<RequestEntryT> entry, boolean insertAtHead) {
        if (this.bufferedRequestEntries.isEmpty() && !this.existsActiveTimerCallback) {
            this.registerCallback();
        }
        if (entry.getSize() > this.maxRecordSizeInBytes) {
            throw new IllegalArgumentException(String.format("The request entry sent to the buffer was of size [%s], when the maxRecordSizeInBytes was set to [%s].", entry.getSize(), this.maxRecordSizeInBytes));
        }
        this.bufferedRequestEntries.add(entry, insertAtHead);
    }

    public void flush(boolean flush) throws InterruptedException {
        while (this.inFlightRequestsCount > 0 || !this.bufferedRequestEntries.isEmpty() && flush) {
            this.yieldIfThereExistsInFlightRequests();
            if (!flush) continue;
            this.flush();
        }
    }

    private void yieldIfThereExistsInFlightRequests() throws InterruptedException {
        if (this.inFlightRequestsCount > 0) {
            this.mailboxExecutor.yield();
        }
    }

    public List<BufferedRequestState<RequestEntryT>> snapshotState(long checkpointId) {
        return Collections.singletonList(new BufferedRequestState<RequestEntryT>(this.bufferedRequestEntries));
    }

    private void initializeState(Collection<BufferedRequestState<RequestEntryT>> states) {
        for (BufferedRequestState<RequestEntryT> state : states) {
            for (RequestEntryWrapper<RequestEntryT> wrapper : state.getBufferedRequestEntries()) {
                this.addEntryToBuffer(wrapper, false);
            }
        }
    }

    public void close() {
    }

    private int getNextBatchSizeLimit() {
        return Math.min(this.maxBatchSize, this.rateLimitingStrategy.getMaxBatchSize());
    }

    protected Consumer<Exception> getFatalExceptionCons() {
        return this.fatalExceptionCons;
    }

    private class AsyncSinkWriterResultHandler
    implements ResultHandler<RequestEntryT> {
        private final ScheduledFuture<?> scheduledFuture;
        private final long requestTimestamp;
        private final int batchSize;
        private final AtomicBoolean isCompleted = new AtomicBoolean(false);
        private final List<RequestEntryT> batchEntries;

        public AsyncSinkWriterResultHandler(long requestTimestamp, List<RequestEntryT> batchEntries, RequestInfo requestInfo) {
            this.scheduledFuture = AsyncSinkWriter.this.timeService.registerTimer(AsyncSinkWriter.this.timeService.getCurrentProcessingTime() + AsyncSinkWriter.this.requestTimeoutMS, instant -> this.timeout());
            this.requestTimestamp = requestTimestamp;
            this.batchEntries = batchEntries;
            this.batchSize = requestInfo.getBatchSize();
        }

        @Override
        public void complete() {
            if (this.isCompleted.compareAndSet(false, true)) {
                this.scheduledFuture.cancel(false);
                AsyncSinkWriter.this.mailboxExecutor.execute(() -> AsyncSinkWriter.this.completeRequest(Collections.emptyList(), this.batchSize, this.requestTimestamp), "Mark in-flight request as completed successfully for batch with size %d", new Object[]{this.batchSize});
            }
        }

        @Override
        public void completeExceptionally(Exception e) {
            if (this.isCompleted.compareAndSet(false, true)) {
                this.scheduledFuture.cancel(false);
                AsyncSinkWriter.this.mailboxExecutor.execute(() -> AsyncSinkWriter.this.getFatalExceptionCons().accept(e), "Mark in-flight request as failed with fatal exception %s", new Object[]{e.getMessage()});
            }
        }

        @Override
        public void retryForEntries(List<RequestEntryT> requestEntriesToRetry) {
            if (this.isCompleted.compareAndSet(false, true)) {
                this.scheduledFuture.cancel(false);
                AsyncSinkWriter.this.mailboxExecutor.execute(() -> AsyncSinkWriter.this.completeRequest(requestEntriesToRetry, this.batchSize, this.requestTimestamp), "Mark in-flight request as completed with %d failed request entries", new Object[]{requestEntriesToRetry.size()});
            }
        }

        public void timeout() {
            if (this.isCompleted.compareAndSet(false, true)) {
                AsyncSinkWriter.this.mailboxExecutor.execute(() -> {
                    if (AsyncSinkWriter.this.failOnTimeout) {
                        AsyncSinkWriter.this.getFatalExceptionCons().accept(new TimeoutException("Request timed out after " + AsyncSinkWriter.this.requestTimeoutMS + "ms with failOnTimeout set to true."));
                    } else {
                        AsyncSinkWriter.this.completeRequest(this.batchEntries, this.batchSize, this.requestTimestamp);
                    }
                }, "Mark in-flight request as completed with timeout after %l", new Object[]{AsyncSinkWriter.this.requestTimeoutMS});
            }
        }
    }
}

