/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.deltajoin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.functions.async.CollectionSupplier;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.TableAbstractCoUdfStreamOperator;
import org.apache.flink.table.runtime.operators.join.deltajoin.AsyncDeltaJoinRunner;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.AecRecord;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.TableAsyncExecutionController;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingDeltaJoinOperator
extends TableAbstractCoUdfStreamOperator<RowData, AsyncDeltaJoinRunner, AsyncDeltaJoinRunner>
implements TwoInputStreamOperator<RowData, RowData, RowData>,
BoundedMultiInput {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingDeltaJoinOperator.class);
    private static final long serialVersionUID = 1L;
    private static final int LEFT_INPUT_INDEX = 0;
    private static final int RIGHT_INPUT_INDEX = 1;
    private static final String STATE_NAME = "_delta_join_operator_async_wait_state_";
    private static final String METRIC_DELTA_JOIN_OP_TOTAL_IN_FLIGHT_NUM = "deltaJoinOpTotalInFlightNum";
    private static final String METRIC_DELTA_JOIN_ASYNC_IO_TIME = "deltaJoinAsyncIoTime";
    private final StreamRecord<RowData> leftEmptyStreamRecord;
    private final StreamRecord<RowData> rightEmptyStreamRecord;
    private final RowDataKeySelector leftJoinKeySelector;
    private final RowDataKeySelector rightJoinKeySelector;
    private final long timeout;
    private final int capacity;
    private transient boolean needDeepCopy;
    private transient StreamElementSerializer<RowData> leftStreamElementSerializer;
    private transient StreamElementSerializer<RowData> rightStreamElementSerializer;
    private transient TimestampedCollector<RowData> timestampedCollector;
    private transient ListState<Tuple4<StreamElement, StreamElement, StreamElement, Integer>> recoveredStreamElements;
    private transient TableAsyncExecutionController<RowData, RowData, RowData> asyncExecutionController;
    private final transient MailboxExecutor mailboxExecutor;
    private final boolean[] isInputEnded;
    private final transient AtomicInteger totalInflightNum = new AtomicInteger(0);
    private final transient AtomicLong asyncIOTime = new AtomicLong(Long.MIN_VALUE);
    private transient BlockingQueue<ReusableKeyedResultHandler> resultHandlerBuffer;
    private transient List<ReusableKeyedResultHandler> allResultHandlers;

    public StreamingDeltaJoinOperator(AsyncDeltaJoinRunner rightLookupTableAsyncFunction, AsyncDeltaJoinRunner leftLookupTableAsyncFunction, RowDataKeySelector leftJoinKeySelector, RowDataKeySelector rightJoinKeySelector, long timeout, int capacity, ProcessingTimeService processingTimeService, MailboxExecutor mailboxExecutor, RowType leftStreamType, RowType rightStreamType) {
        super(rightLookupTableAsyncFunction, leftLookupTableAsyncFunction);
        this.leftJoinKeySelector = leftJoinKeySelector;
        this.rightJoinKeySelector = rightJoinKeySelector;
        this.timeout = timeout;
        this.capacity = capacity;
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
        this.mailboxExecutor = mailboxExecutor;
        this.isInputEnded = new boolean[2];
        this.leftEmptyStreamRecord = new StreamRecord((Object)new GenericRowData(leftStreamType.getFieldCount()));
        this.rightEmptyStreamRecord = new StreamRecord((Object)new GenericRowData(rightStreamType.getFieldCount()));
    }

    @Override
    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<RowData>> output) {
        super.setup(containingTask, config, output);
        this.leftStreamElementSerializer = new StreamElementSerializer(this.getOperatorConfig().getTypeSerializerIn(0, this.getUserCodeClassloader()));
        this.rightStreamElementSerializer = new StreamElementSerializer(this.getOperatorConfig().getTypeSerializerIn(1, this.getUserCodeClassloader()));
        this.timestampedCollector = new TimestampedCollector(this.output);
        this.asyncExecutionController = new TableAsyncExecutionController(this::invoke, (ThrowingConsumer<Watermark, Exception>)((ThrowingConsumer)this::emitWatermark), entry -> {
            entry.emitResult(this.timestampedCollector);
            this.totalInflightNum.decrementAndGet();
        }, entry -> {
            Preconditions.checkState((boolean)(entry instanceof InputIndexAwareStreamRecordQueueEntry), (Object)("The entry type is " + entry.getClass().getSimpleName()));
            return ((InputIndexAwareStreamRecordQueueEntry)entry).inputIndex;
        }, (record, inputIndex) -> {
            RowDataKeySelector keySelector = StreamingDeltaJoinOperator.isLeft(inputIndex) ? this.leftJoinKeySelector : this.rightJoinKeySelector;
            return (RowData)keySelector.getKey((RowData)record.getValue());
        });
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        TypeInformation stateTypeInfo = Types.TUPLE((TypeInformation[])new TypeInformation[]{TypeInformation.of(StreamElement.class), TypeInformation.of(StreamElement.class), TypeInformation.of(StreamElement.class), BasicTypeInfo.INT_TYPE_INFO});
        Class type = stateTypeInfo.getTypeClass();
        TypeSerializer[] stateElementSerializers = new TypeSerializer[]{this.leftStreamElementSerializer, this.rightStreamElementSerializer, this.leftStreamElementSerializer, IntSerializer.INSTANCE};
        TupleSerializer stateSerializer = new TupleSerializer(type, stateElementSerializers);
        this.recoveredStreamElements = context.getKeyedStateStore().getListState(new ListStateDescriptor(STATE_NAME, (TypeSerializer)stateSerializer));
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.asyncExecutionController.submitWatermark(mark);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.needDeepCopy = this.getExecutionConfig().isObjectReuseEnabled() && !this.config.isChainStart();
        this.asyncExecutionController.registerMetrics((MetricGroup)this.getRuntimeContext().getMetricGroup());
        this.getRuntimeContext().getMetricGroup().gauge(METRIC_DELTA_JOIN_OP_TOTAL_IN_FLIGHT_NUM, this.totalInflightNum::get);
        this.getRuntimeContext().getMetricGroup().gauge(METRIC_DELTA_JOIN_ASYNC_IO_TIME, this.asyncIOTime::get);
        this.resultHandlerBuffer = new ArrayBlockingQueue<ReusableKeyedResultHandler>(this.capacity + 1);
        this.allResultHandlers = new ArrayList<ReusableKeyedResultHandler>(this.capacity + 1);
        for (int i = 0; i < this.capacity + 1; ++i) {
            ReusableKeyedResultHandler reusableKeyedResultHandler = new ReusableKeyedResultHandler(this.resultHandlerBuffer);
            this.resultHandlerBuffer.add(reusableKeyedResultHandler);
            this.allResultHandlers.add(reusableKeyedResultHandler);
        }
        List<Object> keys = this.getAllStateKeys();
        for (Object key : keys) {
            this.setCurrentKey(key);
            this.triggerRecoveryProcess();
        }
    }

    public void processElement1(StreamRecord<RowData> element) throws Exception {
        this.processElement(element, 0);
    }

    public void processElement2(StreamRecord<RowData> element) throws Exception {
        this.processElement(element, 1);
    }

    public void emitWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
    }

    public void invoke(AecRecord<RowData, RowData> element) throws Exception {
        ReusableKeyedResultHandler resultHandler = this.resultHandlerBuffer.take();
        resultHandler.reset(element);
        boolean isLeft = StreamingDeltaJoinOperator.isLeft(element.getInputIndex());
        if (this.timeout > 0L) {
            resultHandler.registerTimeout(this.getProcessingTimeService(), this.timeout, isLeft);
        }
        if (isLeft) {
            ((AsyncDeltaJoinRunner)this.leftTriggeredUserFunction).asyncInvoke((RowData)element.getRecord().getValue(), resultHandler);
        } else {
            ((AsyncDeltaJoinRunner)this.rightTriggeredUserFunction).asyncInvoke((RowData)element.getRecord().getValue(), resultHandler);
        }
    }

    private void tryProcess() throws Exception {
        while (this.totalInflightNum.get() >= this.capacity) {
            LOG.debug("Failed to put element into asyncExecutionController because totalInflightNum is greater or equal to maxInflight ({}/{}).", (Object)this.totalInflightNum.get(), (Object)this.capacity);
            this.mailboxExecutor.yield();
        }
        this.totalInflightNum.incrementAndGet();
    }

    private void processElement(StreamRecord<RowData> element, int inputIndex) throws Exception {
        Preconditions.checkArgument((RowKind.INSERT == ((RowData)element.getValue()).getRowKind() ? 1 : 0) != 0, (Object)"Currently, delta join only supports to consume append only stream.");
        this.tryProcess();
        boolean isLeft = StreamingDeltaJoinOperator.isLeft(inputIndex);
        StreamRecord record = this.needDeepCopy ? (isLeft ? (StreamRecord)this.leftStreamElementSerializer.copy(element) : (StreamRecord)this.rightStreamElementSerializer.copy(element)) : element;
        this.asyncExecutionController.submitRecord((StreamRecord<RowData>)record, null, inputIndex);
    }

    private void triggerRecoveryProcess() throws Exception {
        if (this.recoveredStreamElements != null) {
            for (Tuple4 tuple : (Iterable)this.recoveredStreamElements.get()) {
                this.tryProcess();
                int inputIndex = Objects.requireNonNull((Integer)tuple.f3);
                if (StreamingDeltaJoinOperator.isLeft(inputIndex)) {
                    this.asyncExecutionController.recovery((StreamRecord<RowData>)((StreamRecord)tuple.f0), (Watermark)tuple.f2, (Integer)tuple.f3);
                    continue;
                }
                this.asyncExecutionController.recovery((StreamRecord<RowData>)((StreamRecord)tuple.f1), (Watermark)tuple.f2, (Integer)tuple.f3);
            }
        }
    }

    public OperatorSnapshotFutures snapshotState(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, CheckpointStreamFactory factory) throws Exception {
        this.clearLegacyState();
        Map<RowData, Deque<AecRecord<RowData, RowData>>> pendingElements = this.asyncExecutionController.pendingElements();
        for (Map.Entry<RowData, Deque<AecRecord<RowData, RowData>>> entry : pendingElements.entrySet()) {
            RowData key = entry.getKey();
            this.setCurrentKey(key);
            Deque<AecRecord<RowData, RowData>> elements = entry.getValue();
            ArrayList<Tuple4> storedData = new ArrayList<Tuple4>();
            for (AecRecord<RowData, RowData> aecRecord : elements) {
                if (StreamingDeltaJoinOperator.isLeft(aecRecord.getInputIndex())) {
                    storedData.add(Tuple4.of(aecRecord.getRecord(), this.rightEmptyStreamRecord, (Object)aecRecord.getEpoch().getWatermark(), (Object)aecRecord.getInputIndex()));
                    continue;
                }
                storedData.add(Tuple4.of(this.leftEmptyStreamRecord, aecRecord.getRecord(), (Object)aecRecord.getEpoch().getWatermark(), (Object)aecRecord.getInputIndex()));
            }
            this.recoveredStreamElements.update(storedData);
        }
        return super.snapshotState(checkpointId, timestamp, checkpointOptions, factory);
    }

    private void clearLegacyState() {
        List<Object> allKeys = this.getAllStateKeys();
        for (Object key : allKeys) {
            this.setCurrentKey(key);
            this.recoveredStreamElements.clear();
        }
    }

    private List<Object> getAllStateKeys() {
        return this.getKeyedStateBackend().getKeys(STATE_NAME, (Object)VoidNamespace.INSTANCE).collect(Collectors.toList());
    }

    private ScheduledFuture<?> registerTimer(ProcessingTimeService processingTimeService, long timeout, ThrowingConsumer<Void, Exception> callback) {
        long timeoutTimestamp = timeout + processingTimeService.getCurrentProcessingTime();
        return processingTimeService.registerTimer(timeoutTimestamp, timestamp -> callback.accept(null));
    }

    private boolean allInflightFinished() {
        return this.totalInflightNum.get() == 0;
    }

    public void endInput(int inputId) throws Exception {
        this.isInputEnded[inputId - 1] = true;
        if (!this.allInputEnded()) {
            return;
        }
        this.waitInFlightInputsFinished();
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.allResultHandlers != null) {
            for (ReusableKeyedResultHandler handler : this.allResultHandlers) {
                handler.close();
            }
        }
    }

    public void waitInFlightInputsFinished() throws InterruptedException {
        while (!this.allInflightFinished()) {
            this.mailboxExecutor.yield();
        }
    }

    @VisibleForTesting
    public TableAsyncExecutionController<RowData, RowData, RowData> getAsyncExecutionController() {
        return this.asyncExecutionController;
    }

    @VisibleForTesting
    public void setAsyncExecutionController(TableAsyncExecutionController<RowData, RowData, RowData> asyncExecutionController) {
        this.asyncExecutionController = asyncExecutionController;
    }

    private boolean allInputEnded() {
        return this.isInputEnded[0] && this.isInputEnded[1];
    }

    private static boolean isLeft(int inputIndex) {
        if (0 == inputIndex) {
            return true;
        }
        if (1 == inputIndex) {
            return false;
        }
        throw new IllegalArgumentException("Unknown input index: " + inputIndex);
    }

    @VisibleForTesting
    public static class InputIndexAwareStreamRecordQueueEntry
    implements StreamElementQueueEntry<RowData> {
        private StreamRecord<?> inputRecord;
        private Collection<RowData> completedElements;
        private int inputIndex;

        public void reset(StreamRecord<?> inputRecord, int inputIndex) {
            this.inputRecord = (StreamRecord)Preconditions.checkNotNull(inputRecord);
            this.inputIndex = inputIndex;
            this.completedElements = null;
        }

        public boolean isDone() {
            return this.completedElements != null;
        }

        @Nonnull
        public StreamRecord<?> getInputElement() {
            return this.inputRecord;
        }

        public void emitResult(TimestampedCollector<RowData> output) {
            output.setTimestamp(this.inputRecord);
            for (RowData r : this.completedElements) {
                output.collect((Object)r);
            }
        }

        public void complete(Collection<RowData> result) {
            this.completedElements = (Collection)Preconditions.checkNotNull(result);
        }

        public int getInputIndex() {
            return this.inputIndex;
        }
    }

    private class ReusableKeyedResultHandler
    implements ResultFuture<RowData> {
        private final AtomicBoolean completed = new AtomicBoolean(false);
        private final BlockingQueue<ReusableKeyedResultHandler> resultHandlerBuffer;
        private ScheduledFuture<?> timeoutTimer;
        private AecRecord<RowData, RowData> inputRecord;
        private final InputIndexAwareStreamRecordQueueEntry reusedQueueEntry;
        private volatile long startTime;

        ReusableKeyedResultHandler(BlockingQueue<ReusableKeyedResultHandler> resultHandlerBuffer) {
            this.resultHandlerBuffer = resultHandlerBuffer;
            this.reusedQueueEntry = new InputIndexAwareStreamRecordQueueEntry();
        }

        public void reset(AecRecord<RowData, RowData> inputAecRecord) {
            this.inputRecord = inputAecRecord;
            this.startTime = System.currentTimeMillis();
            this.timeoutTimer = null;
            this.reusedQueueEntry.reset(inputAecRecord.getRecord(), this.inputRecord.getInputIndex());
            this.completed.set(false);
        }

        public void complete(Collection<RowData> results) {
            if (!this.completed.compareAndSet(false, true)) {
                return;
            }
            this.processInMailbox(results);
        }

        public void completeExceptionally(Throwable error) {
            if (!this.completed.compareAndSet(false, true)) {
                return;
            }
            LOG.error("An error happen when doing delta join", error);
            StreamingDeltaJoinOperator.this.getContainingTask().getEnvironment().failExternally((Throwable)new Exception("Could not complete the stream element: " + String.valueOf(this.inputRecord) + ".", error));
            this.processInMailbox(Collections.emptyList());
        }

        public void close() {
            if (this.timeoutTimer != null) {
                this.timeoutTimer.cancel(true);
            }
        }

        public void complete(CollectionSupplier<RowData> supplier) {
            throw new UnsupportedOperationException();
        }

        private void processInMailbox(Collection<RowData> results) {
            StreamingDeltaJoinOperator.this.mailboxExecutor.execute(() -> this.processResults(results), "Result in AsyncWaitOperator of input %s", new Object[]{results});
        }

        private void processResults(Collection<RowData> results) throws Exception {
            StreamingDeltaJoinOperator.this.asyncIOTime.set(System.currentTimeMillis() - this.startTime);
            if (this.timeoutTimer != null) {
                this.timeoutTimer.cancel(true);
            }
            this.reusedQueueEntry.complete(results);
            StreamingDeltaJoinOperator.this.asyncExecutionController.completeRecord(this.reusedQueueEntry, this.inputRecord);
            try {
                this.resultHandlerBuffer.put(this);
            }
            catch (InterruptedException e) {
                this.completeExceptionally(e);
            }
        }

        private void registerTimeout(ProcessingTimeService processingTimeService, long timeout, boolean isLeft) {
            this.timeoutTimer = StreamingDeltaJoinOperator.this.registerTimer(processingTimeService, timeout, (ThrowingConsumer<Void, Exception>)((ThrowingConsumer)VOID -> this.timerTriggered(isLeft)));
        }

        private void timerTriggered(boolean isLeft) throws Exception {
            if (!this.completed.get()) {
                if (isLeft) {
                    ((AsyncDeltaJoinRunner)StreamingDeltaJoinOperator.this.leftTriggeredUserFunction).timeout((RowData)this.inputRecord.getRecord().getValue(), this);
                } else {
                    ((AsyncDeltaJoinRunner)StreamingDeltaJoinOperator.this.rightTriggeredUserFunction).timeout((RowData)this.inputRecord.getRecord().getValue(), this);
                }
            }
        }
    }
}

