/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank.window;

import java.time.ZoneId;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.RecordsWindowBuffer;
import org.apache.flink.table.runtime.operators.rank.window.combines.TopNRecordsCombiner;
import org.apache.flink.table.runtime.operators.rank.window.processors.SyncStateWindowRankProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAggOperator;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.util.Preconditions;

public class WindowRankOperatorBuilder {
    private AbstractRowDataSerializer<RowData> inputSerializer;
    private PagedTypeSerializer<RowData> keySerializer;
    private RowDataKeySelector sortKeySelector;
    private GeneratedRecordComparator generatedSortKeyComparator;
    private boolean outputRankNumber;
    private long rankStart = -1L;
    private long rankEnd = -1L;
    private int windowEndIndex = -1;
    private ZoneId shiftTimeZone;
    private Boolean isEventTime;

    public static WindowRankOperatorBuilder builder() {
        return new WindowRankOperatorBuilder();
    }

    public WindowRankOperatorBuilder inputSerializer(AbstractRowDataSerializer<RowData> inputSerializer) {
        this.inputSerializer = inputSerializer;
        return this;
    }

    public WindowRankOperatorBuilder shiftTimeZone(ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        return this;
    }

    public WindowRankOperatorBuilder keySerializer(PagedTypeSerializer<RowData> keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    public WindowRankOperatorBuilder sortKeySelector(RowDataKeySelector sortKeySelector) {
        this.sortKeySelector = sortKeySelector;
        return this;
    }

    public WindowRankOperatorBuilder sortKeyComparator(GeneratedRecordComparator genSortKeyComparator) {
        this.generatedSortKeyComparator = genSortKeyComparator;
        return this;
    }

    public WindowRankOperatorBuilder outputRankNumber(boolean outputRankNumber) {
        this.outputRankNumber = outputRankNumber;
        return this;
    }

    public WindowRankOperatorBuilder rankStart(long rankStart) {
        this.rankStart = rankStart;
        return this;
    }

    public WindowRankOperatorBuilder rankEnd(long rankEnd) {
        this.rankEnd = rankEnd;
        return this;
    }

    public WindowRankOperatorBuilder windowEndIndex(int windowEndIndex) {
        this.windowEndIndex = windowEndIndex;
        return this;
    }

    public WindowRankOperatorBuilder withEventTime(Boolean isEventTime) {
        this.isEventTime = isEventTime;
        return this;
    }

    public WindowAggOperator<RowData, ?> build() {
        Preconditions.checkNotNull(this.inputSerializer);
        Preconditions.checkNotNull(this.keySerializer);
        Preconditions.checkNotNull((Object)this.sortKeySelector);
        Preconditions.checkNotNull((Object)this.generatedSortKeyComparator);
        Preconditions.checkNotNull((Object)this.isEventTime);
        Preconditions.checkArgument((this.rankStart > 0L ? 1 : 0) != 0, (Object)String.format("Illegal rank start %s, it should be positive!", this.rankStart));
        Preconditions.checkArgument((this.rankEnd >= 1L ? 1 : 0) != 0, (Object)String.format("Illegal rank end %s, it should be at least 1!", this.rankEnd));
        Preconditions.checkArgument((this.rankEnd >= this.rankStart ? 1 : 0) != 0, (Object)String.format("Illegal rank start %s and rank end %s, rank start should not be bigger than or equal to rank end!", this.rankStart, this.rankEnd));
        Preconditions.checkArgument((this.windowEndIndex >= 0 ? 1 : 0) != 0, (Object)String.format("Illegal window end index %s, it should not be negative!", this.windowEndIndex));
        TopNRecordsCombiner.Factory combinerFactory = new TopNRecordsCombiner.Factory(this.generatedSortKeyComparator, this.sortKeySelector, this.inputSerializer, this.rankEnd);
        RecordsWindowBuffer.Factory bufferFactory = new RecordsWindowBuffer.Factory(this.keySerializer, this.inputSerializer, combinerFactory);
        SyncStateWindowRankProcessor windowProcessor = new SyncStateWindowRankProcessor(this.inputSerializer, this.generatedSortKeyComparator, this.sortKeySelector.getProducedType().toSerializer(), bufferFactory, this.rankStart, this.rankEnd, this.outputRankNumber, this.windowEndIndex, this.shiftTimeZone);
        return new WindowAggOperator(windowProcessor, this.isEventTime);
    }
}

