/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank.window.combines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.TopNBuffer;
import org.apache.flink.table.runtime.operators.window.tvf.combines.RecordsCombiner;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.tvf.state.StateKeyContext;
import org.apache.flink.table.runtime.operators.window.tvf.state.WindowMapState;
import org.apache.flink.table.runtime.operators.window.tvf.state.WindowState;
import org.apache.flink.table.runtime.util.WindowKey;

public final class TopNRecordsCombiner
implements RecordsCombiner {
    private final WindowTimerService<Long> timerService;
    private final StateKeyContext keyContext;
    private final WindowMapState<Long, List<RowData>> dataState;
    private final Comparator<RowData> sortKeyComparator;
    private final KeySelector<RowData, RowData> sortKeySelector;
    private final long topN;
    private final TypeSerializer<RowData> recordSerializer;
    private final boolean isEventTime;

    public TopNRecordsCombiner(WindowTimerService<Long> timerService, StateKeyContext keyContext, WindowMapState<Long, List<RowData>> dataState, Comparator<RowData> sortKeyComparator, KeySelector<RowData, RowData> sortKeySelector, long topN, TypeSerializer<RowData> recordSerializer, boolean isEventTime) {
        this.timerService = timerService;
        this.keyContext = keyContext;
        this.dataState = dataState;
        this.sortKeyComparator = sortKeyComparator;
        this.sortKeySelector = sortKeySelector;
        this.topN = topN;
        this.recordSerializer = recordSerializer;
        this.isEventTime = isEventTime;
    }

    @Override
    public void combine(WindowKey windowKey, Iterator<RowData> records) throws Exception {
        TopNBuffer buffer = new TopNBuffer(this.sortKeyComparator, ArrayList::new);
        while (records.hasNext()) {
            RowData record = records.next();
            if (!RowDataUtil.isAccumulateMsg(record)) {
                throw new UnsupportedOperationException("Window rank does not support input RowKind: " + record.getRowKind().shortString());
            }
            RowData sortKey = (RowData)this.sortKeySelector.getKey((Object)record);
            if (!buffer.checkSortKeyInBufferRange(sortKey, this.topN)) continue;
            buffer.put(sortKey, (RowData)this.recordSerializer.copy((Object)record));
        }
        Iterator<Map.Entry<RowData, Collection<RowData>>> bufferItr = buffer.entrySet().iterator();
        this.keyContext.setCurrentKey(windowKey.getKey());
        Long window = windowKey.getWindow();
        while (bufferItr.hasNext()) {
            Map.Entry<RowData, Collection<RowData>> entry = bufferItr.next();
            RowData sortKey = entry.getKey();
            List<RowData> existsData = this.dataState.get(window, sortKey);
            if (existsData == null) {
                existsData = new ArrayList<RowData>();
            }
            existsData.addAll(entry.getValue());
            this.dataState.put(window, sortKey, existsData);
        }
        if (this.isEventTime) {
            this.timerService.registerEventTimeWindowTimer(window);
        }
    }

    @Override
    public void close() throws Exception {
    }

    public static final class Factory
    implements RecordsCombiner.Factory {
        private static final long serialVersionUID = 1L;
        private final GeneratedRecordComparator generatedSortKeyComparator;
        private final KeySelector<RowData, RowData> sortKeySelector;
        private final TypeSerializer<RowData> recordSerializer;
        private final long topN;

        public Factory(GeneratedRecordComparator genSortKeyComparator, RowDataKeySelector sortKeySelector, TypeSerializer<RowData> recordSerializer, long topN) {
            this.generatedSortKeyComparator = genSortKeyComparator;
            this.sortKeySelector = sortKeySelector;
            this.recordSerializer = recordSerializer;
            this.topN = topN;
        }

        @Override
        public RecordsCombiner createRecordsCombiner(RuntimeContext runtimeContext, WindowTimerService<Long> timerService, KeyedStateBackend<RowData> stateBackend, WindowState<Long> windowState, boolean isEventTime) throws Exception {
            Comparator sortKeyComparator = (Comparator)this.generatedSortKeyComparator.newInstance(runtimeContext.getUserCodeClassLoader());
            WindowMapState windowMapState = (WindowMapState)windowState;
            return new TopNRecordsCombiner(timerService, arg_0 -> stateBackend.setCurrentKey(arg_0), windowMapState, sortKeyComparator, this.sortKeySelector, this.topN, this.recordSerializer, isEventTime);
        }
    }
}

