/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
class DecimalScale0TypeStrategy
implements TypeStrategy {
    DecimalScale0TypeStrategy() {
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        DataType argumentDataType = callContext.getArgumentDataTypes().get(0);
        LogicalType argumentType = argumentDataType.getLogicalType();
        if (argumentType instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataType);
        }
        if (argumentType.is(LogicalTypeRoot.DECIMAL)) {
            if (LogicalTypeChecks.hasScale(argumentType, 0)) {
                return Optional.of(argumentDataType);
            }
            DecimalType inferredType = new DecimalType(argumentType.isNullable(), LogicalTypeChecks.getPrecision(argumentType), 0);
            return Optional.of(TypeConversions.fromLogicalToDataType(inferredType));
        }
        return Optional.empty();
    }
}

