/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StoreFileInfo {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFileInfo.class);
    public static final String HFILE_NAME_REGEX = "[0-9a-f]+(?:(?:_SeqId_[0-9]+_)|(?:_del))?";
    private static final Pattern HFILE_NAME_PATTERN = Pattern.compile("^([0-9a-f]+(?:(?:_SeqId_[0-9]+_)|(?:_del))?)");
    public static final String DELFILE_NAME_REGEX = "[0-9a-f]+(?:_del)";
    private static final Pattern DELFILE_NAME_PATTERN = Pattern.compile("^([0-9a-f]+(?:_del))");
    private static final Pattern REF_NAME_PATTERN = Pattern.compile(String.format("^(%s|%s)\\.(.+)$", "[0-9a-f]+(?:(?:_SeqId_[0-9]+_)|(?:_del))?", HFileLink.LINK_NAME_REGEX));
    public static final String STORE_FILE_READER_NO_READAHEAD = "hbase.store.reader.no-readahead";
    public static final boolean DEFAULT_STORE_FILE_READER_NO_READAHEAD = false;
    private final Configuration conf;
    private final FileSystem fs;
    private HDFSBlocksDistribution hdfsBlocksDistribution = null;
    private HFileInfo hfileInfo;
    private final Reference reference;
    private final HFileLink link;
    private final Path initialPath;
    private RegionCoprocessorHost coprocessorHost;
    private long createdTimestamp;
    private long size;
    private final boolean primaryReplica;
    private final boolean noReadahead;
    final AtomicInteger refCount = new AtomicInteger(0);

    public StoreFileInfo(Configuration conf, FileSystem fs, Path initialPath, boolean primaryReplica) throws IOException {
        this(conf, fs, null, initialPath, primaryReplica);
    }

    private StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus, Path initialPath, boolean primaryReplica) throws IOException {
        assert (fs != null);
        assert (initialPath != null);
        assert (conf != null);
        this.fs = fs;
        this.conf = conf;
        this.initialPath = initialPath;
        this.primaryReplica = primaryReplica;
        this.noReadahead = this.conf.getBoolean(STORE_FILE_READER_NO_READAHEAD, false);
        Path p = initialPath;
        if (HFileLink.isHFileLink(p)) {
            this.reference = null;
            this.link = HFileLink.buildFromHFileLinkPattern(conf, p);
            LOG.trace("{} is a link", (Object)p);
        } else if (StoreFileInfo.isReference(p)) {
            this.reference = Reference.read(fs, p);
            Path referencePath = StoreFileInfo.getReferredToFile(p);
            this.link = HFileLink.isHFileLink(referencePath) ? HFileLink.buildFromHFileLinkPattern(conf, referencePath) : null;
            LOG.trace("{} is a {} reference to {}", new Object[]{p, this.reference.getFileRegion(), referencePath});
        } else if (StoreFileInfo.isHFile(p)) {
            if (fileStatus != null) {
                this.createdTimestamp = fileStatus.getModificationTime();
                this.size = fileStatus.getLen();
            } else {
                FileStatus fStatus = fs.getFileStatus(initialPath);
                this.createdTimestamp = fStatus.getModificationTime();
                this.size = fStatus.getLen();
            }
            this.reference = null;
            this.link = null;
        } else {
            throw new IOException("path=" + p + " doesn't look like a valid StoreFile");
        }
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus) throws IOException {
        this(conf, fs, fileStatus, fileStatus.getPath(), true);
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus, HFileLink link) {
        this(conf, fs, fileStatus, null, link);
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus, Reference reference) {
        this(conf, fs, fileStatus, reference, null);
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus, Reference reference, HFileLink link) {
        this.fs = fs;
        this.conf = conf;
        this.primaryReplica = false;
        this.initialPath = fileStatus == null ? null : fileStatus.getPath();
        this.createdTimestamp = fileStatus == null ? 0L : fileStatus.getModificationTime();
        this.reference = reference;
        this.link = link;
        this.noReadahead = this.conf.getBoolean(STORE_FILE_READER_NO_READAHEAD, false);
    }

    public long getSize() {
        return this.size;
    }

    public void setRegionCoprocessorHost(RegionCoprocessorHost coprocessorHost) {
        this.coprocessorHost = coprocessorHost;
    }

    public Reference getReference() {
        return this.reference;
    }

    public boolean isReference() {
        return this.reference != null;
    }

    public boolean isTopReference() {
        return this.reference != null && Reference.isTopFileRegion(this.reference.getFileRegion());
    }

    public boolean isLink() {
        return this.link != null && this.reference == null;
    }

    public HDFSBlocksDistribution getHDFSBlockDistribution() {
        return this.hdfsBlocksDistribution;
    }

    StoreFileReader createReader(ReaderContext context, CacheConfig cacheConf) throws IOException {
        StoreFileReader reader = null;
        reader = this.reference != null ? new HalfStoreFileReader(context, this.hfileInfo, cacheConf, this.reference, this.refCount, this.conf) : new StoreFileReader(context, this.hfileInfo, cacheConf, this.refCount, this.conf);
        return reader;
    }

    ReaderContext createReaderContext(boolean doDropBehind, long readahead, ReaderContext.ReaderType type) throws IOException {
        FileStatus status;
        FSDataInputStreamWrapper in;
        if (this.link != null) {
            in = new FSDataInputStreamWrapper(this.fs, this.link, doDropBehind, readahead);
            status = this.link.getFileStatus(this.fs);
        } else if (this.reference != null) {
            Path referencePath = StoreFileInfo.getReferredToFile(this.getPath());
            try {
                in = new FSDataInputStreamWrapper(this.fs, referencePath, doDropBehind, readahead);
            }
            catch (FileNotFoundException fnfe) {
                FileNotFoundException newFnfe = new FileNotFoundException(this.toString());
                newFnfe.initCause(fnfe);
                throw newFnfe;
            }
            status = this.fs.getFileStatus(referencePath);
        } else {
            in = new FSDataInputStreamWrapper(this.fs, this.getPath(), doDropBehind, readahead);
            status = this.fs.getFileStatus(this.initialPath);
        }
        long length = status.getLen();
        ReaderContextBuilder contextBuilder = new ReaderContextBuilder().withInputStreamWrapper(in).withFileSize(length).withPrimaryReplicaReader(this.primaryReplica).withReaderType(type).withFileSystem(this.fs);
        if (this.reference != null) {
            contextBuilder.withFilePath(this.getPath());
        } else {
            contextBuilder.withFilePath(status.getPath());
        }
        return contextBuilder.build();
    }

    public HDFSBlocksDistribution computeHDFSBlocksDistribution(FileSystem fs) throws IOException {
        if (this.link != null) {
            FileNotFoundException exToThrow = null;
            for (int i = 0; i < this.link.getLocations().length; ++i) {
                try {
                    return this.computeHDFSBlocksDistributionInternal(fs);
                }
                catch (FileNotFoundException ex) {
                    exToThrow = ex;
                    continue;
                }
            }
            throw exToThrow;
        }
        return this.computeHDFSBlocksDistributionInternal(fs);
    }

    private HDFSBlocksDistribution computeHDFSBlocksDistributionInternal(FileSystem fs) throws IOException {
        FileStatus status = this.getReferencedFileStatus(fs);
        if (this.reference != null) {
            return StoreFileInfo.computeRefFileHDFSBlockDistribution(fs, this.reference, status);
        }
        return FSUtils.computeHDFSBlocksDistribution(fs, status, 0L, status.getLen());
    }

    public FileStatus getReferencedFileStatus(FileSystem fs) throws IOException {
        FileStatus status;
        if (this.reference != null) {
            if (this.link != null) {
                FileNotFoundException exToThrow = null;
                for (int i = 0; i < this.link.getLocations().length; ++i) {
                    try {
                        return this.link.getFileStatus(fs);
                    }
                    catch (FileNotFoundException ex) {
                        exToThrow = ex;
                        continue;
                    }
                }
                throw exToThrow;
            }
            Path referencePath = StoreFileInfo.getReferredToFile(this.getPath());
            status = fs.getFileStatus(referencePath);
        } else {
            if (this.link != null) {
                FileNotFoundException exToThrow = null;
                for (int i = 0; i < this.link.getLocations().length; ++i) {
                    try {
                        return this.link.getFileStatus(fs);
                    }
                    catch (FileNotFoundException ex) {
                        exToThrow = ex;
                        continue;
                    }
                }
                throw exToThrow;
            }
            status = fs.getFileStatus(this.initialPath);
        }
        return status;
    }

    public Path getPath() {
        return this.initialPath;
    }

    public FileStatus getFileStatus() throws IOException {
        return this.getReferencedFileStatus(this.fs);
    }

    public long getModificationTime() throws IOException {
        return this.getFileStatus().getModificationTime();
    }

    public String toString() {
        return this.getPath() + (this.isReference() ? "->" + StoreFileInfo.getReferredToFile(this.getPath()) + "-" + this.reference : "");
    }

    public static boolean isHFile(Path path) {
        return StoreFileInfo.isHFile(path.getName());
    }

    public static boolean isHFile(String fileName) {
        Matcher m = HFILE_NAME_PATTERN.matcher(fileName);
        return m.matches() && m.groupCount() > 0;
    }

    public static boolean isDelFile(Path path) {
        return StoreFileInfo.isDelFile(path.getName());
    }

    public static boolean isDelFile(String fileName) {
        Matcher m = DELFILE_NAME_PATTERN.matcher(fileName);
        return m.matches() && m.groupCount() > 0;
    }

    public static boolean isReference(Path path) {
        return StoreFileInfo.isReference(path.getName());
    }

    public static boolean isReference(String name) {
        Matcher m = REF_NAME_PATTERN.matcher(name);
        return m.matches() && m.groupCount() > 1;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public static Path getReferredToFile(Path p) {
        Matcher m = REF_NAME_PATTERN.matcher(p.getName());
        if (m == null || !m.matches()) {
            LOG.warn("Failed match of store file name {}", (Object)p.toString());
            throw new IllegalArgumentException("Failed match of store file name " + p.toString());
        }
        String otherRegion = m.group(2);
        Path tableDir = p.getParent().getParent().getParent();
        String nameStrippedOfSuffix = m.group(1);
        LOG.trace("reference {} to region={} hfile={}", new Object[]{p, otherRegion, nameStrippedOfSuffix});
        return new Path(new Path(new Path(tableDir, otherRegion), p.getParent().getName()), nameStrippedOfSuffix);
    }

    public static Pair<String, String> getReferredToRegionAndFile(String referenceFile) {
        Matcher m = REF_NAME_PATTERN.matcher(referenceFile);
        if (m == null || !m.matches()) {
            LOG.warn("Failed match of store file name {}", (Object)referenceFile);
            throw new IllegalArgumentException("Failed match of store file name " + referenceFile);
        }
        String referencedRegion = m.group(2);
        String referencedFile = m.group(1);
        LOG.trace("reference {} to region={} file={}", new Object[]{referenceFile, referencedRegion, referencedFile});
        return new Pair((Object)referencedRegion, (Object)referencedFile);
    }

    public static boolean validateStoreFileName(String fileName) {
        if (HFileLink.isHFileLink(fileName) || StoreFileInfo.isReference(fileName)) {
            return true;
        }
        return !fileName.contains("-");
    }

    public static boolean isValid(FileStatus fileStatus) throws IOException {
        Path p = fileStatus.getPath();
        if (fileStatus.isDirectory()) {
            return false;
        }
        if (!HFileLink.isHFileLink(p) && fileStatus.getLen() <= 0L) {
            LOG.warn("Skipping {} because it is empty. HBASE-646 DATA LOSS?", (Object)p);
            return false;
        }
        return StoreFileInfo.validateStoreFileName(p.getName());
    }

    private static HDFSBlocksDistribution computeRefFileHDFSBlockDistribution(FileSystem fs, Reference reference, FileStatus status) throws IOException {
        if (status == null) {
            return null;
        }
        long start = 0L;
        long length = 0L;
        if (Reference.isTopFileRegion(reference.getFileRegion())) {
            start = status.getLen() / 2L;
            length = status.getLen() - status.getLen() / 2L;
        } else {
            start = 0L;
            length = status.getLen() / 2L;
        }
        return FSUtils.computeHDFSBlocksDistribution(fs, status, start, length);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof StoreFileInfo)) {
            return false;
        }
        StoreFileInfo o = (StoreFileInfo)that;
        if (this.initialPath != null && o.initialPath == null) {
            return false;
        }
        if (this.initialPath == null && o.initialPath != null) {
            return false;
        }
        if (this.initialPath != o.initialPath && this.initialPath != null && !this.initialPath.equals((Object)o.initialPath)) {
            return false;
        }
        if (this.reference != null && o.reference == null) {
            return false;
        }
        if (this.reference == null && o.reference != null) {
            return false;
        }
        if (this.reference != o.reference && this.reference != null && !this.reference.equals(o.reference)) {
            return false;
        }
        if (this.link != null && o.link == null) {
            return false;
        }
        if (this.link == null && o.link != null) {
            return false;
        }
        return this.link == o.link || this.link == null || this.link.equals(o.link);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.reference == null ? 0 : this.reference.hashCode());
        hash = hash * 31 + (this.initialPath == null ? 0 : this.initialPath.hashCode());
        hash = hash * 31 + (this.link == null ? 0 : this.link.hashCode());
        return hash;
    }

    public String getActiveFileName() {
        if (this.reference != null || this.link == null) {
            return this.initialPath.getName();
        }
        return HFileLink.getReferencedHFileName(this.initialPath.getName());
    }

    FileSystem getFileSystem() {
        return this.fs;
    }

    Configuration getConf() {
        return this.conf;
    }

    boolean isNoReadahead() {
        return this.noReadahead;
    }

    HFileInfo getHFileInfo() {
        return this.hfileInfo;
    }

    void initHDFSBlocksDistribution() throws IOException {
        this.hdfsBlocksDistribution = this.computeHDFSBlocksDistribution(this.fs);
    }

    StoreFileReader preStoreFileReaderOpen(ReaderContext context, CacheConfig cacheConf) throws IOException {
        StoreFileReader reader = null;
        if (this.coprocessorHost != null) {
            reader = this.coprocessorHost.preStoreFileReaderOpen(this.fs, this.getPath(), context.getInputStreamWrapper(), context.getFileSize(), cacheConf, this.reference);
        }
        return reader;
    }

    StoreFileReader postStoreFileReaderOpen(ReaderContext context, CacheConfig cacheConf, StoreFileReader reader) throws IOException {
        StoreFileReader res = reader;
        if (this.coprocessorHost != null) {
            res = this.coprocessorHost.postStoreFileReaderOpen(this.fs, this.getPath(), context.getInputStreamWrapper(), context.getFileSize(), cacheConf, this.reference, reader);
        }
        return res;
    }

    public void initHFileInfo(ReaderContext context) throws IOException {
        this.hfileInfo = new HFileInfo(context, this.conf);
    }
}

