/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.junit.rules.ExternalResource;

public final class MiniClusterRule
extends ExternalResource {
    private final HBaseTestingUtility testingUtility;
    private final StartMiniClusterOption miniClusterOptions;
    private MiniHBaseCluster miniCluster;

    private MiniClusterRule(Configuration conf, StartMiniClusterOption miniClusterOptions) {
        this.testingUtility = new HBaseTestingUtility(conf);
        this.miniClusterOptions = miniClusterOptions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public HBaseTestingUtility getTestingUtility() {
        return this.testingUtility;
    }

    public Connection createConnection() {
        if (this.miniCluster == null) {
            throw new IllegalStateException("test cluster not initialized");
        }
        try {
            return ConnectionFactory.createConnection((Configuration)this.miniCluster.getConf());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<AsyncConnection> createAsyncConnection() {
        if (this.miniCluster == null) {
            throw new IllegalStateException("test cluster not initialized");
        }
        return ConnectionFactory.createAsyncConnection((Configuration)this.miniCluster.getConf());
    }

    protected void before() throws Throwable {
        this.miniCluster = this.testingUtility.startMiniCluster(this.miniClusterOptions);
    }

    protected void after() {
        try {
            this.testingUtility.shutdownMiniCluster();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private StartMiniClusterOption miniClusterOption;
        private Configuration conf;

        public Builder setMiniClusterOption(StartMiniClusterOption miniClusterOption) {
            this.miniClusterOption = miniClusterOption;
            return this;
        }

        public Builder setConfiguration(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public MiniClusterRule build() {
            return new MiniClusterRule(this.conf, this.miniClusterOption != null ? this.miniClusterOption : StartMiniClusterOption.builder().build());
        }
    }
}

