/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FilterTests.class, LargeTests.class})
public class TestFuzzyRowFilterEndToEndLarge {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFuzzyRowFilterEndToEndLarge.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFuzzyRowFilterEndToEndLarge.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte fuzzyValue = 63;
    private static int firstPartCardinality = 30;
    private static int secondPartCardinality = 30;
    private static int thirdPartCardinality = 30;
    private static int colQualifiersTotal = 5;
    private static int totalFuzzyKeys = thirdPartCardinality / 2;
    private static String table = "TestFuzzyRowFilterEndToEndLarge";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.scanner.caching", 1000);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.setLong("hbase.hregion.max.filesize", 0x280000000L);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testEndToEnd() throws Exception {
        String cf = "f";
        Table ht = TEST_UTIL.createTable(TableName.valueOf((String)table), Bytes.toBytes((String)cf), Integer.MAX_VALUE);
        for (int i0 = 0; i0 < firstPartCardinality; ++i0) {
            for (int i1 = 0; i1 < secondPartCardinality; ++i1) {
                for (int i2 = 0; i2 < thirdPartCardinality; ++i2) {
                    byte[] rk = new byte[10];
                    ByteBuffer buf = ByteBuffer.wrap(rk);
                    buf.clear();
                    buf.putShort((short)i0);
                    buf.putInt(i1);
                    buf.putInt(i2);
                    for (int c = 0; c < colQualifiersTotal; ++c) {
                        byte[] cq = new byte[4];
                        Bytes.putBytes((byte[])cq, (int)0, (byte[])Bytes.toBytes((int)c), (int)0, (int)4);
                        Put p = new Put(rk);
                        p.setDurability(Durability.SKIP_WAL);
                        p.addColumn(cf.getBytes(), cq, Bytes.toBytes((int)c));
                        ht.put(p);
                    }
                }
            }
        }
        TEST_UTIL.flush();
        this.runTest1(ht, (byte)0);
        this.runTest1(ht, (byte)2);
        this.runTest2(ht, (byte)0);
        this.runTest2(ht, (byte)2);
    }

    private void runTest1(Table hTable, byte processedWildcardMask) throws IOException {
        byte[] mask = new byte[]{0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (int i = 0; i < totalFuzzyKeys; ++i) {
            byte[] fuzzyKey = new byte[10];
            ByteBuffer buf = ByteBuffer.wrap(fuzzyKey);
            buf.clear();
            buf.putShort((short)2);
            for (int j = 0; j < 4; ++j) {
                buf.put((byte)63);
            }
            buf.putInt(i);
            Pair pair = new Pair((Object)fuzzyKey, (Object)mask);
            list.add(pair);
        }
        int expectedSize = secondPartCardinality * totalFuzzyKeys * colQualifiersTotal;
        FuzzyRowFilter fuzzyRowFilter0 = new FuzzyRowFilter(list, processedWildcardMask);
        FuzzyRowFilter fuzzyRowFilter1 = new FuzzyRowFilter(list, processedWildcardMask);
        this.runScanner(hTable, expectedSize, (Filter)fuzzyRowFilter0);
        this.runScanner(hTable, expectedSize, (Filter)fuzzyRowFilter1);
    }

    private void runTest2(Table hTable, byte processedWildcardMask) throws IOException {
        byte[] mask = new byte[]{0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (int i = 0; i < totalFuzzyKeys; ++i) {
            byte[] fuzzyKey = new byte[10];
            ByteBuffer buf = ByteBuffer.wrap(fuzzyKey);
            buf.clear();
            buf.putShort((short)(i * 2));
            for (int j = 0; j < 4; ++j) {
                buf.put((byte)63);
            }
            buf.putInt(i * 2);
            Pair pair = new Pair((Object)fuzzyKey, (Object)mask);
            list.add(pair);
        }
        int expectedSize = totalFuzzyKeys * secondPartCardinality * colQualifiersTotal;
        FuzzyRowFilter fuzzyRowFilter0 = new FuzzyRowFilter(list, processedWildcardMask);
        FuzzyRowFilter fuzzyRowFilter1 = new FuzzyRowFilter(list, processedWildcardMask);
        this.runScanner(hTable, expectedSize, (Filter)fuzzyRowFilter0);
        this.runScanner(hTable, expectedSize, (Filter)fuzzyRowFilter1);
    }

    private void runScanner(Table hTable, int expectedSize, Filter filter) throws IOException {
        String cf = "f";
        Scan scan = new Scan();
        scan.addFamily(cf.getBytes());
        scan.setFilter(filter);
        List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(table.getBytes());
        HRegion first = regions.get(0);
        first.getScanner(scan);
        HRegion.RegionScannerImpl scanner = first.getScanner(scan);
        ArrayList results = new ArrayList();
        long timeBeforeScan = System.currentTimeMillis();
        int found = 0;
        while (scanner.next(results)) {
            found += results.size();
            results.clear();
        }
        long scanTime = System.currentTimeMillis() - timeBeforeScan;
        scanner.close();
        LOG.info("\nscan time = " + scanTime + "ms");
        LOG.info("found " + (found += results.size()) + " results\n");
        Assert.assertEquals((long)expectedSize, (long)found);
    }
}

