/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionAssignedToMultipleRegionServers {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionAssignedToMultipleRegionServers.class);
    private static final List<ServerName> EXCLUDE_SERVERS = new ArrayList<ServerName>();
    private static boolean HALT = false;
    private static boolean KILL = false;
    private static CountDownLatch ARRIVE;
    private static final HBaseTestingUtility UTIL;
    private static TableName NAME;
    private static byte[] CF;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        UTIL.startMiniCluster(StartMiniClusterOption.builder().numMasters(2).numRegionServers(2).build());
        UTIL.createTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(NAME).get(0).getRegionInfo();
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        RegionStateNode rsn = am.getRegionStates().getRegionStateNode(region);
        ServerName sn = rsn.getRegionLocation();
        ARRIVE = new CountDownLatch(1);
        HALT = true;
        am.moveAsync(new RegionPlan(region, sn, sn));
        ARRIVE.await();
        EXCLUDE_SERVERS.add(rsn.getRegionLocation());
        KILL = true;
        HMaster activeMaster = UTIL.getMiniHBaseCluster().getMaster();
        activeMaster.abort("For testing");
        activeMaster.join();
        KILL = false;
        Thread.sleep(10000L);
        HALT = false;
        Thread.sleep(5000L);
        HRegionServer rs = UTIL.getMiniHBaseCluster().getRegionServer(sn);
        Assert.assertNotNull((Object)rs.getRegion(region.getEncodedName()));
        Assert.assertNull((Object)UTIL.getOtherRegionServer(rs).getRegion(region.getEncodedName()));
    }

    static {
        UTIL = new HBaseTestingUtility();
        NAME = TableName.valueOf((String)"Assign");
        CF = Bytes.toBytes((String)"cf");
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master) {
            return new AssignmentManagerForTest(master);
        }

        protected ServerManager createServerManager(MasterServices master) throws IOException {
            this.setupClusterConnection();
            return new ServerManagerForTest(master);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master) {
            super(master);
        }

        public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws PleaseHoldException {
            if (req.getTransition(0).getTransitionCode() == RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED) {
                if (ARRIVE != null) {
                    ARRIVE.countDown();
                    ARRIVE = null;
                }
                while (HALT) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (!KILL) continue;
                    throw new PleaseHoldException("Inject error!");
                }
            }
            return super.reportRegionStateTransition(req);
        }
    }

    private static final class ServerManagerForTest
    extends ServerManager {
        public ServerManagerForTest(MasterServices master) {
            super(master);
        }

        public List<ServerName> createDestinationServersList() {
            return super.createDestinationServersList(EXCLUDE_SERVERS);
        }
    }
}

