/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.region.MasterRegionParams;
import org.apache.hadoop.hbase.master.region.MasterRegionTestBase;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterRegionCompaction
extends MasterRegionTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRegionCompaction.class);
    private int compactMin = 4;
    private HFileCleaner hfileCleaner;

    @Override
    protected void configure(MasterRegionParams params) {
        params.compactMin(this.compactMin);
    }

    @Override
    protected void postSetUp() throws IOException {
        Configuration conf = this.htu.getConfiguration();
        conf.setLong("hbase.master.local.store.hfilecleaner.ttl", 5000L);
        Path testDir = this.htu.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(conf);
        Path globalArchivePath = HFileArchiveUtil.getArchivePath((Configuration)conf);
        this.hfileCleaner = new HFileCleaner(500, new Stoppable(){
            private volatile boolean stopped = false;

            public void stop(String why) {
                this.stopped = true;
            }

            public boolean isStopped() {
                return this.stopped;
            }
        }, conf, fs, globalArchivePath, this.hfileCleanerPool);
        this.choreService.scheduleChore((ScheduledChore)this.hfileCleaner);
    }

    private int getStorefilesCount() {
        return this.region.region.getStores().stream().mapToInt(Store::getStorefilesCount).sum();
    }

    private void assertFileCount(FileSystem fs, Path storeArchiveDir, int expected) throws IOException {
        FileStatus[] compactedHFiles = fs.listStatus(storeArchiveDir);
        Assert.assertEquals((long)expected, (long)compactedHFiles.length);
    }

    @Test
    public void test() throws IOException, InterruptedException {
        int i = 0;
        while (i < this.compactMin - 1) {
            int index = i++;
            this.region.update(r -> r.put(new Put(Bytes.toBytes((int)index)).addColumn(CF1, QUALIFIER, Bytes.toBytes((int)index)).addColumn(CF2, QUALIFIER, Bytes.toBytes((int)index))));
            this.region.flush(true);
        }
        Assert.assertEquals((long)(2 * (this.compactMin - 1)), (long)this.getStorefilesCount());
        this.region.update(r -> r.put(new Put(Bytes.toBytes((int)(this.compactMin - 1))).addColumn(CF1, QUALIFIER, Bytes.toBytes((int)(this.compactMin - 1)))));
        this.region.flusherAndCompactor.requestFlush();
        this.htu.waitFor(15000L, () -> this.getStorefilesCount() == 2);
        Path store1ArchiveDir = HFileArchiveUtil.getStoreArchivePathForRootDir((Path)this.htu.getDataTestDir(), (RegionInfo)this.region.region.getRegionInfo(), (byte[])CF1);
        Path store2ArchiveDir = HFileArchiveUtil.getStoreArchivePathForRootDir((Path)this.htu.getDataTestDir(), (RegionInfo)this.region.region.getRegionInfo(), (byte[])CF2);
        FileSystem fs = store1ArchiveDir.getFileSystem(this.htu.getConfiguration());
        this.htu.waitFor(15000L, () -> {
            try {
                FileStatus[] fses1 = fs.listStatus(store1ArchiveDir);
                FileStatus[] fses2 = fs.listStatus(store2ArchiveDir);
                return fses1 != null && fses1.length == this.compactMin && fses2 != null && fses2.length == this.compactMin - 1;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        });
        Thread.sleep(1000L);
        FileStatus[] compactedHFiles = fs.listStatus(store1ArchiveDir);
        Assert.assertEquals((long)this.compactMin, (long)compactedHFiles.length);
        this.assertFileCount(fs, store2ArchiveDir, this.compactMin - 1);
        Thread.sleep(2000L);
        long currentTime = System.currentTimeMillis();
        fs.setTimes(compactedHFiles[0].getPath(), currentTime, currentTime);
        Thread.sleep(3000L);
        FileStatus[] remainingHFiles = fs.listStatus(store1ArchiveDir);
        Assert.assertEquals((long)1L, (long)remainingHFiles.length);
        Assert.assertEquals((Object)compactedHFiles[0].getPath(), (Object)remainingHFiles[0].getPath());
        Assert.assertFalse((boolean)fs.exists(store2ArchiveDir));
        Thread.sleep(6000L);
        Assert.assertFalse((boolean)fs.exists(store1ArchiveDir));
    }
}

