/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestKeyValueHeap
extends HBaseTestCase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestKeyValueHeap.class);
    private byte[] row1 = Bytes.toBytes((String)"row1");
    private byte[] fam1 = Bytes.toBytes((String)"fam1");
    private byte[] col1 = Bytes.toBytes((String)"col1");
    private byte[] data = Bytes.toBytes((String)"data");
    private byte[] row2 = Bytes.toBytes((String)"row2");
    private byte[] fam2 = Bytes.toBytes((String)"fam2");
    private byte[] col2 = Bytes.toBytes((String)"col2");
    private byte[] col3 = Bytes.toBytes((String)"col3");
    private byte[] col4 = Bytes.toBytes((String)"col4");
    private byte[] col5 = Bytes.toBytes((String)"col5");
    Cell kv111 = new KeyValue(this.row1, this.fam1, this.col1, this.data);
    Cell kv112 = new KeyValue(this.row1, this.fam1, this.col2, this.data);
    Cell kv113 = new KeyValue(this.row1, this.fam1, this.col3, this.data);
    Cell kv114 = new KeyValue(this.row1, this.fam1, this.col4, this.data);
    Cell kv115 = new KeyValue(this.row1, this.fam1, this.col5, this.data);
    Cell kv121 = new KeyValue(this.row1, this.fam2, this.col1, this.data);
    Cell kv122 = new KeyValue(this.row1, this.fam2, this.col2, this.data);
    Cell kv211 = new KeyValue(this.row2, this.fam1, this.col1, this.data);
    Cell kv212 = new KeyValue(this.row2, this.fam1, this.col2, this.data);
    Cell kv213 = new KeyValue(this.row2, this.fam1, this.col3, this.data);
    TestScanner s1 = new TestScanner(Arrays.asList(this.kv115, this.kv211, this.kv212));
    TestScanner s2 = new TestScanner(Arrays.asList(this.kv111, this.kv112));
    TestScanner s3 = new TestScanner(Arrays.asList(this.kv113, this.kv114, this.kv121, this.kv122, this.kv213));
    List<KeyValueScanner> scanners = new ArrayList<TestScanner>(Arrays.asList(this.s1, this.s2, this.s3));

    public List<Cell> assertCells(List<Cell> expected, List<KeyValueScanner> scanners) throws IOException {
        KeyValueHeap kvh = new KeyValueHeap(scanners, (CellComparator)CellComparatorImpl.COMPARATOR);
        ArrayList<Cell> actual = new ArrayList<Cell>();
        while (kvh.peek() != null) {
            actual.add(kvh.next());
        }
        TestKeyValueHeap.assertEquals(expected, actual);
        return actual;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testSorted() throws IOException {
        List<Cell> expected = Arrays.asList(this.kv111, this.kv112, this.kv113, this.kv114, this.kv115, this.kv121, this.kv122, this.kv211, this.kv212, this.kv213);
        List<Cell> actual = this.assertCells(expected, this.scanners);
        for (int i = 0; i < actual.size() - 1; ++i) {
            int ret = CellComparatorImpl.COMPARATOR.compare(actual.get(i), actual.get(i + 1));
            TestKeyValueHeap.assertTrue((ret < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSeek() throws IOException {
        List<Cell> expected = Arrays.asList(this.kv211);
        KeyValueHeap kvh = new KeyValueHeap(this.scanners, (CellComparator)CellComparatorImpl.COMPARATOR);
        KeyValue seekKv = new KeyValue(this.row2, this.fam1, null, null);
        kvh.seek((Cell)seekKv);
        List<Cell> actual = Arrays.asList(kvh.peek());
        TestKeyValueHeap.assertEquals((String)("Expected = " + Arrays.toString(expected.toArray()) + "\n Actual = " + Arrays.toString(actual.toArray())), expected, actual);
    }

    @Test
    public void testScannerLeak() throws IOException {
        TestScanner s4 = new TestScanner(new ArrayList<Cell>());
        this.scanners.add((KeyValueScanner)s4);
        KeyValueHeap kvh = new KeyValueHeap(this.scanners, (CellComparator)CellComparatorImpl.COMPARATOR);
        while (kvh.next() != null) {
        }
        TestKeyValueHeap.assertEquals((int)4, (int)kvh.scannersForDelayedClose.size());
        TestKeyValueHeap.assertTrue((boolean)kvh.scannersForDelayedClose.contains((Object)this.s1));
        TestKeyValueHeap.assertTrue((boolean)kvh.scannersForDelayedClose.contains((Object)this.s2));
        TestKeyValueHeap.assertTrue((boolean)kvh.scannersForDelayedClose.contains((Object)this.s3));
        TestKeyValueHeap.assertTrue((boolean)kvh.scannersForDelayedClose.contains((Object)s4));
        kvh.close();
        for (KeyValueScanner scanner : this.scanners) {
            TestKeyValueHeap.assertTrue((boolean)((TestScanner)scanner).isClosed());
        }
    }

    @Test
    public void testScannerException() throws IOException {
        SeekTestScanner s1 = new SeekTestScanner(Arrays.asList(this.kv115, this.kv211, this.kv212));
        SeekTestScanner s2 = new SeekTestScanner(Arrays.asList(this.kv111, this.kv112));
        SeekTestScanner s3 = new SeekTestScanner(Arrays.asList(this.kv113, this.kv114, this.kv121, this.kv122, this.kv213));
        SeekTestScanner s4 = new SeekTestScanner(new ArrayList<Cell>());
        ArrayList<TestScanner> scanners = new ArrayList<TestScanner>(Arrays.asList(new TestScanner[]{s1, s2, s3, s4}));
        KeyValueHeap kvh = new KeyValueHeap(scanners, (CellComparator)CellComparatorImpl.COMPARATOR);
        try {
            for (KeyValueScanner keyValueScanner : scanners) {
                ((SeekTestScanner)keyValueScanner).setRealSeekDone(false);
            }
            while (kvh.next() != null) {
            }
            TestKeyValueHeap.assertTrue((boolean)false);
        }
        catch (IOException ioe) {
            kvh.close();
        }
        for (KeyValueScanner keyValueScanner : scanners) {
            TestKeyValueHeap.assertTrue((boolean)((SeekTestScanner)keyValueScanner).isClosed());
            TestKeyValueHeap.assertEquals((int)1, (int)((SeekTestScanner)keyValueScanner).getClosedNum());
        }
    }

    @Test
    public void testPriorityId() throws IOException {
        KeyValue kv113A = new KeyValue(this.row1, this.fam1, this.col3, Bytes.toBytes((String)"aaa"));
        KeyValue kv113B = new KeyValue(this.row1, this.fam1, this.col3, Bytes.toBytes((String)"bbb"));
        TestScanner scan1 = new TestScanner(Arrays.asList(this.kv111, this.kv112, kv113A), 1L);
        TestScanner scan2 = new TestScanner(Arrays.asList(kv113B), 2L);
        List<Cell> expected = Arrays.asList(this.kv111, this.kv112, kv113B, kv113A);
        this.assertCells(expected, new ArrayList<TestScanner>(Arrays.asList(scan1, scan2)));
        scan1 = new TestScanner(Arrays.asList(this.kv111, this.kv112, kv113A), 2L);
        scan2 = new TestScanner(Arrays.asList(kv113B), 1L);
        expected = Arrays.asList(this.kv111, this.kv112, kv113A, kv113B);
        this.assertCells(expected, new ArrayList<TestScanner>(Arrays.asList(scan1, scan2)));
    }

    private static class SeekTestScanner
    extends TestScanner {
        private int closedNum = 0;
        private boolean realSeekDone = true;

        public SeekTestScanner(List<Cell> list) {
            super(list);
        }

        @Override
        public void close() {
            super.close();
            ++this.closedNum;
        }

        public int getClosedNum() {
            return this.closedNum;
        }

        public boolean realSeekDone() {
            return this.realSeekDone;
        }

        public void setRealSeekDone(boolean done) {
            this.realSeekDone = done;
        }

        public void enforceSeek() throws IOException {
            throw new IOException("enforceSeek must not be called on a non-lazy scanner");
        }
    }

    private static class TestScanner
    extends CollectionBackedScanner {
        private boolean closed = false;
        private long scannerOrder = 0L;

        public TestScanner(List<Cell> list) {
            super(list);
        }

        public TestScanner(List<Cell> list, long scannerOrder) {
            this(list);
            this.scannerOrder = scannerOrder;
        }

        public long getScannerOrder() {
            return this.scannerOrder;
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

