/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestSettingTimeoutOnBlockingPoint {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSettingTimeoutOnBlockingPoint.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAM = Bytes.toBytes((String)"f");
    private static final byte[] ROW1 = Bytes.toBytes((String)"row1");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    @Rule
    public TestName testName = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.status.published", true);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.handler.count", 2);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void setUpAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowLock() throws IOException {
        TableName tableName = TableName.valueOf((String)this.testName.getMethodName());
        HTableDescriptor hdt = TEST_UTIL.createTableDescriptor(tableName);
        hdt.addCoprocessor(SleepCoprocessor.class.getName());
        TEST_UTIL.createTable((TableDescriptor)hdt, (byte[][])new byte[][]{FAM}, TEST_UTIL.getConfiguration());
        Thread incrementThread = new Thread(() -> {
            try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
                table.incrementColumnValue(ROW1, FAM, FAM, 1L);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        Thread getThread = new Thread(() -> {
            try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
                table.setRpcTimeout(1000);
                Delete delete = new Delete(ROW1);
                table.delete(delete);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        incrementThread.start();
        Threads.sleep((long)1000L);
        getThread.start();
        Threads.sleep((long)2000L);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            table.setRpcTimeout(1000);
            table.get(new Get(ROW2));
        }
        finally {
            incrementThread.interrupt();
            getThread.interrupt();
        }
    }

    public static class SleepCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public static final int SLEEP_TIME = 10000;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
            Threads.sleep((long)10000L);
            return null;
        }
    }
}

