/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionMover;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
public class TestRegionMover2 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionMover2.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionMover2.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 4);
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"fam1")).build();
        int startKey = 0;
        int endKey = 80000;
        TEST_UTIL.getAdmin().createTable(tableDesc, Bytes.toBytes((int)startKey), Bytes.toBytes((int)endKey), 9);
    }

    @After
    public void tearDown() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.getAdmin().disableTable(tableName);
        TEST_UTIL.getAdmin().deleteTable(tableName);
    }

    @Test
    public void testWithSplitRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        Admin admin = TEST_UTIL.getAdmin();
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 10; i < 50000; ++i) {
            puts.add(new Put(Bytes.toBytes((int)i)).addColumn(Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)("val_" + i))));
        }
        table.put(puts);
        admin.flush(tableName);
        admin.compact(tableName);
        HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getAddress().toString();
        int numRegions = regionServer.getNumberOfOnlineRegions();
        List hRegions = regionServer.getRegions().stream().filter(hRegion -> hRegion.getRegionInfo().getTable().equals((Object)tableName)).collect(Collectors.toList());
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rsName, TEST_UTIL.getConfiguration()).ack(true).maxthreads(8);
        try (RegionMover rm = rmBuilder.build();){
            LOG.debug("Unloading {}", (Object)regionServer.getServerName());
            rm.unload();
            Assert.assertEquals((long)0L, (long)regionServer.getNumberOfOnlineRegions());
            LOG.debug("Successfully Unloaded, now Loading");
            HRegion hRegion2 = (HRegion)hRegions.get(1);
            if (hRegion2.getRegionInfo().getStartKey().length == 0) {
                hRegion2 = (HRegion)hRegions.get(0);
            }
            int startKey = 0;
            int endKey = Integer.MAX_VALUE;
            if (hRegion2.getRegionInfo().getStartKey().length > 0) {
                startKey = Bytes.toInt((byte[])hRegion2.getRegionInfo().getStartKey());
            }
            if (hRegion2.getRegionInfo().getEndKey().length > 0) {
                endKey = Bytes.toInt((byte[])hRegion2.getRegionInfo().getEndKey());
            }
            int midKey = startKey + (endKey - startKey) / 2;
            admin.splitRegionAsync(hRegion2.getRegionInfo().getRegionName(), Bytes.toBytes((int)midKey)).get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)rm.load());
            Assert.assertEquals((long)(numRegions - 1), (long)regionServer.getNumberOfOnlineRegions());
        }
    }

    @Test
    public void testFailedRegionMove() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        Admin admin = TEST_UTIL.getAdmin();
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 1000; ++i) {
            puts.add(new Put(Bytes.toBytes((String)("rowkey_" + i))).addColumn(Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)("val_" + i))));
        }
        table.put(puts);
        admin.flush(tableName);
        HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getAddress().toString();
        List hRegions = regionServer.getRegions().stream().filter(hRegion -> hRegion.getRegionInfo().getTable().equals((Object)tableName)).collect(Collectors.toList());
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rsName, TEST_UTIL.getConfiguration()).ack(true).maxthreads(8);
        try (RegionMover rm = rmBuilder.build();){
            LOG.debug("Unloading {}", (Object)regionServer.getServerName());
            rm.unload();
            Assert.assertEquals((long)0L, (long)regionServer.getNumberOfOnlineRegions());
            LOG.debug("Successfully Unloaded, now Loading");
            admin.offline(((HRegion)hRegions.get(0)).getRegionInfo().getRegionName());
            Assert.assertFalse((boolean)rm.load());
        }
    }

    public void loadDummyDataInTable(TableName tableName) throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 1000; ++i) {
            puts.add(new Put(Bytes.toBytes((String)("rowkey_" + i))).addColumn(Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)("val_" + i))));
        }
        table.put(puts);
        admin.flush(tableName);
    }

    @Test
    public void testIsolateSingleRegionOnTheSameServer() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.loadDummyDataInTable(tableName);
        ServerName sourceServerName = this.findSourceServerName(tableName);
        this.regionIsolationOperation(sourceServerName, sourceServerName, 1, false);
    }

    @Test
    public void testIsolateSingleRegionOnTheDifferentServer() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.loadDummyDataInTable(tableName);
        ServerName sourceServerName = this.findSourceServerName(tableName);
        ServerName destinationServerName = this.findDestinationServerName(sourceServerName);
        this.regionIsolationOperation(sourceServerName, destinationServerName, 1, false);
    }

    @Test
    public void testIsolateMultipleRegionsOnTheSameServer() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.loadDummyDataInTable(tableName);
        ServerName sourceServerName = this.findSourceServerName(tableName);
        this.regionIsolationOperation(sourceServerName, sourceServerName, 2, false);
    }

    @Test
    public void testIsolateMultipleRegionsOnTheDifferentServer() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.loadDummyDataInTable(tableName);
        ServerName sourceServerName = this.findSourceServerName(tableName);
        ServerName destinationServerName = this.findDestinationServerName(sourceServerName);
        this.regionIsolationOperation(sourceServerName, destinationServerName, 2, false);
    }

    @Test
    public void testIsolateMetaOnTheSameSever() throws Exception {
        ServerName metaServerSource = this.findMetaRSLocation();
        this.regionIsolationOperation(metaServerSource, metaServerSource, 1, true);
    }

    @Test
    public void testIsolateMetaOnTheDifferentServer() throws Exception {
        ServerName metaServerSource = this.findMetaRSLocation();
        ServerName metaServerDestination = this.findDestinationServerName(metaServerSource);
        this.regionIsolationOperation(metaServerSource, metaServerDestination, 1, true);
    }

    @Test
    public void testIsolateMetaAndRandomRegionOnTheMetaServer() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.loadDummyDataInTable(tableName);
        ServerName metaServerSource = this.findMetaRSLocation();
        ServerName randomSeverRegion = this.findSourceServerName(tableName);
        this.regionIsolationOperation(randomSeverRegion, metaServerSource, 2, true);
    }

    @Test
    public void testIsolateMetaAndRandomRegionOnTheRandomServer() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.loadDummyDataInTable(tableName);
        ServerName randomSeverRegion = this.findSourceServerName(tableName);
        this.regionIsolationOperation(randomSeverRegion, randomSeverRegion, 2, true);
    }

    public ServerName findMetaRSLocation() throws Exception {
        ZKWatcher zkWatcher = new ZKWatcher(TEST_UTIL.getConfiguration(), null, null);
        ArrayList<HRegionLocation> result = new ArrayList<HRegionLocation>();
        for (String znode : zkWatcher.getMetaReplicaNodes()) {
            String path = ZNodePaths.joinZNode((String)zkWatcher.getZNodePaths().baseZNode, (String)znode);
            int replicaId = zkWatcher.getZNodePaths().getMetaReplicaIdFromPath(path);
            RegionState state = MetaTableLocator.getMetaRegionState((ZKWatcher)zkWatcher, (int)replicaId);
            result.add(new HRegionLocation(state.getRegion(), state.getServerName()));
        }
        return ((HRegionLocation)result.get(0)).getServerName();
    }

    public ServerName findSourceServerName(TableName tableName) throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        int numOfRS = cluster.getNumLiveRegionServers();
        ServerName sourceServer = null;
        for (int i = 0; i < numOfRS; ++i) {
            HRegionServer regionServer = cluster.getRegionServer(i);
            List hRegions = regionServer.getRegions().stream().filter(hRegion -> hRegion.getRegionInfo().getTable().equals((Object)tableName)).collect(Collectors.toList());
            if (hRegions.size() < 2) continue;
            sourceServer = regionServer.getServerName();
            break;
        }
        if (sourceServer == null) {
            throw new Exception("This shouln't happen, No RS found with more than 2 regions of table : " + tableName);
        }
        return sourceServer;
    }

    public ServerName findDestinationServerName(ServerName sourceServerName) throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        ServerName destinationServerName = null;
        int numOfRS = cluster.getNumLiveRegionServers();
        for (int i = 0; i < numOfRS && (destinationServerName = cluster.getRegionServer(i).getServerName()).equals((Object)sourceServerName); ++i) {
        }
        if (destinationServerName == null) {
            throw new Exception("This shouldn't happen, No RS found which is different than source RS");
        }
        return destinationServerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regionIsolationOperation(ServerName sourceServerName, ServerName destinationServerName, int numRegionsToIsolate, boolean isolateMetaAlso) throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        Admin admin = TEST_UTIL.getAdmin();
        HRegionServer sourceRS = cluster.getRegionServer(sourceServerName);
        List hRegions = sourceRS.getRegions().stream().filter(hRegion -> hRegion.getRegionInfo().getTable().equals((Object)tableName)).collect(Collectors.toList());
        ArrayList<String> listOfRegionIDsToIsolate = new ArrayList<String>();
        for (int i = 0; i < numRegionsToIsolate; ++i) {
            listOfRegionIDsToIsolate.add(((HRegion)hRegions.get(i)).getRegionInfo().getEncodedName());
        }
        if (isolateMetaAlso) {
            listOfRegionIDsToIsolate.remove(0);
            listOfRegionIDsToIsolate.add(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedName());
        }
        HRegionServer destinationRS = cluster.getRegionServer(destinationServerName);
        String destinationRSName = destinationRS.getServerName().getAddress().toString();
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(destinationRSName, TEST_UTIL.getConfiguration()).ack(true).maxthreads(8).isolateRegionIdArray(listOfRegionIDsToIsolate);
        try (RegionMover rm = rmBuilder.build();){
            LOG.debug("Unloading {} except regions : {}", (Object)destinationRS.getServerName(), listOfRegionIDsToIsolate);
            rm.isolateRegions();
            Assert.assertEquals((long)numRegionsToIsolate, (long)destinationRS.getNumberOfOnlineRegions());
            List onlineRegions = destinationRS.getRegions();
            for (int i = 0; i < numRegionsToIsolate; ++i) {
                Assert.assertTrue((boolean)listOfRegionIDsToIsolate.contains(((HRegion)onlineRegions.get(i)).getRegionInfo().getEncodedName()));
            }
            LOG.debug("Successfully Isolated " + listOfRegionIDsToIsolate.size() + " regions : " + listOfRegionIDsToIsolate + " on " + destinationRS.getServerName());
        }
        finally {
            admin.recommissionRegionServer(destinationRS.getServerName(), null);
        }
    }
}

