/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.Screen;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.field.FieldScreenView;
import org.apache.hadoop.hbase.hbtop.screen.help.HelpScreenView;
import org.apache.hadoop.hbase.hbtop.screen.mode.ModeScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.FilterDisplayModeScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.Header;
import org.apache.hadoop.hbase.hbtop.screen.top.InputModeScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.MessageModeScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.Paging;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenModel;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.hbtop.terminal.Terminal;
import org.apache.hadoop.hbase.hbtop.terminal.TerminalSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TopScreenPresenter {
    private final TopScreenView topScreenView;
    private final AtomicLong refreshDelay;
    private long lastRefreshTimestamp;
    private final AtomicBoolean adjustFieldLength = new AtomicBoolean(true);
    private final TopScreenModel topScreenModel;
    private int terminalLength;
    private int horizontalScroll;
    private final Paging paging = new Paging();
    private final EnumMap<Field, Boolean> fieldDisplayMap = new EnumMap(Field.class);
    private final EnumMap<Field, Integer> fieldLengthMap = new EnumMap(Field.class);
    private final long numberOfIterations;
    private long iterations;

    public TopScreenPresenter(TopScreenView topScreenView, long initialRefreshDelay, TopScreenModel topScreenModel, @Nullable List<Field> initialFields, long numberOfIterations) {
        this.topScreenView = Objects.requireNonNull(topScreenView);
        this.refreshDelay = new AtomicLong(initialRefreshDelay);
        this.topScreenModel = Objects.requireNonNull(topScreenModel);
        this.numberOfIterations = numberOfIterations;
        this.initFieldDisplayMapAndFieldLengthMap(initialFields);
    }

    public void init() {
        this.updateTerminalLengthAndPageSize(this.topScreenView.getTerminalSize(), this.topScreenView.getPageSize());
        this.topScreenView.hideCursor();
    }

    private void updateTerminalLengthAndPageSize(@Nullable TerminalSize terminalSize, @Nullable Integer pageSize) {
        this.terminalLength = terminalSize != null ? terminalSize.getColumns() : Integer.MAX_VALUE;
        if (pageSize != null) {
            this.paging.updatePageSize(pageSize);
        } else {
            this.paging.updatePageSize(Integer.MAX_VALUE);
        }
    }

    public long refresh(boolean force) {
        long delay;
        if (!force && (delay = System.currentTimeMillis() - this.lastRefreshTimestamp) < this.refreshDelay.get()) {
            return this.refreshDelay.get() - delay;
        }
        TerminalSize newTerminalSize = this.topScreenView.doResizeIfNecessary();
        if (newTerminalSize != null) {
            this.updateTerminalLengthAndPageSize(newTerminalSize, this.topScreenView.getPageSize());
            this.topScreenView.clearTerminal();
        }
        this.topScreenModel.refreshMetricsData();
        this.paging.updateRecordsSize(this.topScreenModel.getRecords().size());
        this.adjustFieldLengthIfNeeded();
        this.topScreenView.showTopScreen(this.topScreenModel.getSummary(), this.getDisplayedHeaders(), this.getDisplayedRecords(), this.getSelectedRecord());
        this.topScreenView.refreshTerminal();
        this.lastRefreshTimestamp = System.currentTimeMillis();
        ++this.iterations;
        return this.refreshDelay.get();
    }

    public void adjustFieldLength() {
        this.adjustFieldLength.set(true);
        this.refresh(true);
    }

    private void adjustFieldLengthIfNeeded() {
        if (this.adjustFieldLength.get()) {
            this.adjustFieldLength.set(false);
            for (Field f : this.topScreenModel.getFields()) {
                if (!f.isAutoAdjust()) continue;
                int maxLength = this.topScreenModel.getRecords().stream().map(r -> r.get((Object)f).asString().length()).max(Integer::compareTo).orElse(0);
                this.fieldLengthMap.put(f, Math.max(maxLength, f.getHeader().length()));
            }
        }
    }

    private List<Header> getDisplayedHeaders() {
        Field field;
        int fieldLength;
        List displayFields = this.topScreenModel.getFields().stream().filter(this.fieldDisplayMap::get).collect(Collectors.toList());
        if (displayFields.isEmpty()) {
            this.horizontalScroll = 0;
        } else if (this.horizontalScroll > displayFields.size() - 1) {
            this.horizontalScroll = displayFields.size() - 1;
        }
        ArrayList<Header> ret = new ArrayList<Header>();
        int length = 0;
        for (int i = this.horizontalScroll; i < displayFields.size() && (length += (fieldLength = this.fieldLengthMap.get((Object)(field = (Field)((Object)displayFields.get(i)))).intValue()) + 1) <= this.terminalLength; ++i) {
            ret.add(new Header(field, fieldLength));
        }
        return ret;
    }

    private List<Record> getDisplayedRecords() {
        ArrayList<Record> ret = new ArrayList<Record>();
        for (int i = this.paging.getPageStartPosition(); i < this.paging.getPageEndPosition(); ++i) {
            ret.add(this.topScreenModel.getRecords().get(i));
        }
        return ret;
    }

    private Record getSelectedRecord() {
        if (this.topScreenModel.getRecords().isEmpty()) {
            return null;
        }
        return this.topScreenModel.getRecords().get(this.paging.getCurrentPosition());
    }

    public void arrowUp() {
        this.paging.arrowUp();
        this.refresh(true);
    }

    public void arrowDown() {
        this.paging.arrowDown();
        this.refresh(true);
    }

    public void pageUp() {
        this.paging.pageUp();
        this.refresh(true);
    }

    public void pageDown() {
        this.paging.pageDown();
        this.refresh(true);
    }

    public void arrowLeft() {
        if (this.horizontalScroll > 0) {
            --this.horizontalScroll;
        }
        this.refresh(true);
    }

    public void arrowRight() {
        if (this.horizontalScroll < this.getHeaderSize() - 1) {
            ++this.horizontalScroll;
        }
        this.refresh(true);
    }

    public void home() {
        if (this.horizontalScroll > 0) {
            this.horizontalScroll = 0;
        }
        this.refresh(true);
    }

    public void end() {
        int headerSize = this.getHeaderSize();
        this.horizontalScroll = headerSize == 0 ? 0 : headerSize - 1;
        this.refresh(true);
    }

    private int getHeaderSize() {
        return (int)this.topScreenModel.getFields().stream().filter(this.fieldDisplayMap::get).count();
    }

    public void switchSortOrder() {
        this.topScreenModel.switchSortOrder();
        this.refresh(true);
    }

    public ScreenView transitionToHelpScreen(Screen screen, Terminal terminal) {
        return new HelpScreenView(screen, terminal, this.refreshDelay.get(), this.topScreenView);
    }

    public ScreenView transitionToModeScreen(Screen screen, Terminal terminal) {
        return new ModeScreenView(screen, terminal, this.topScreenModel.getCurrentMode(), this::switchMode, this.topScreenView);
    }

    public ScreenView transitionToFieldScreen(Screen screen, Terminal terminal) {
        return new FieldScreenView(screen, terminal, this.topScreenModel.getCurrentSortField(), this.topScreenModel.getFields(), this.fieldDisplayMap, (sortField, fields, fieldDisplayMap) -> {
            this.topScreenModel.setSortFieldAndFields(sortField, fields);
            this.fieldDisplayMap.clear();
            this.fieldDisplayMap.putAll(fieldDisplayMap);
        }, this.topScreenView);
    }

    private void switchMode(Mode nextMode) {
        this.topScreenModel.switchMode(nextMode, false, null);
        this.reset();
    }

    public void drillDown() {
        Record selectedRecord = this.getSelectedRecord();
        if (selectedRecord == null) {
            return;
        }
        if (this.topScreenModel.drillDown(selectedRecord)) {
            this.reset();
            this.refresh(true);
        }
    }

    private void reset() {
        this.initFieldDisplayMapAndFieldLengthMap(null);
        this.adjustFieldLength.set(true);
        this.paging.init();
        this.horizontalScroll = 0;
        this.topScreenView.clearTerminal();
    }

    private void initFieldDisplayMapAndFieldLengthMap(@Nullable List<Field> initialFields) {
        this.fieldDisplayMap.clear();
        this.fieldLengthMap.clear();
        for (FieldInfo fieldInfo : this.topScreenModel.getFieldInfos()) {
            if (initialFields != null) {
                this.fieldDisplayMap.put(fieldInfo.getField(), initialFields.contains((Object)fieldInfo.getField()));
            } else {
                this.fieldDisplayMap.put(fieldInfo.getField(), fieldInfo.isDisplayByDefault());
            }
            this.fieldLengthMap.put(fieldInfo.getField(), fieldInfo.getDefaultLength());
        }
    }

    public ScreenView goToMessageMode(Screen screen, Terminal terminal, int row, String message) {
        return new MessageModeScreenView(screen, terminal, row, message, this.topScreenView);
    }

    public ScreenView goToInputModeForRefreshDelay(Screen screen, Terminal terminal, int row) {
        return new InputModeScreenView(screen, terminal, row, "Change refresh delay from " + (double)this.refreshDelay.get() / 1000.0 + " to", null, inputString -> {
            double delay;
            if (inputString.isEmpty()) {
                return this.topScreenView;
            }
            try {
                delay = Double.parseDouble(inputString);
            }
            catch (NumberFormatException e) {
                return this.goToMessageMode(screen, terminal, row, "Unacceptable floating point");
            }
            this.refreshDelay.set((long)(delay * 1000.0));
            return this.topScreenView;
        });
    }

    public ScreenView goToInputModeForFilter(Screen screen, Terminal terminal, int row, boolean ignoreCase) {
        return new InputModeScreenView(screen, terminal, row, "add filter #" + (this.topScreenModel.getFilters().size() + 1) + " (" + (ignoreCase ? "ignoring case" : "case sensitive") + ") as: [!]FLD?VAL", this.topScreenModel.getFilterHistories(), inputString -> {
            if (inputString.isEmpty()) {
                return this.topScreenView;
            }
            if (!this.topScreenModel.addFilter((String)inputString, ignoreCase)) {
                return this.goToMessageMode(screen, terminal, row, "Unacceptable filter expression");
            }
            this.paging.init();
            return this.topScreenView;
        });
    }

    public void clearFilters() {
        this.topScreenModel.clearFilters();
        this.paging.init();
        this.refresh(true);
    }

    public ScreenView goToFilterDisplayMode(Screen screen, Terminal terminal, int row) {
        ArrayList<RecordFilter> filters = new ArrayList<RecordFilter>(this.topScreenModel.getFilters());
        filters.addAll(this.topScreenModel.getPushDownFilters());
        return new FilterDisplayModeScreenView(screen, terminal, row, filters, this.topScreenView);
    }

    public boolean isIterationFinished() {
        return this.iterations >= this.numberOfIterations;
    }
}

