/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.PathTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.traversal.algorithm.steps.RepeatEdgeStep;
import org.apache.hugegraph.traversal.algorithm.strategy.TraverseStrategy;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class TemplatePathsTraverser
extends HugeTraverser {
    public TemplatePathsTraverser(HugeGraph graph) {
        super(graph);
    }

    public Set<HugeTraverser.Path> templatePaths(Iterator<Vertex> sources, Iterator<Vertex> targets, List<RepeatEdgeStep> steps, boolean withRing, long capacity, long limit) {
        TemplatePathsTraverser.checkCapacity(capacity);
        TemplatePathsTraverser.checkLimit(limit);
        List<Id> sourceList = TemplatePathsTraverser.newList();
        while (sources.hasNext()) {
            sourceList.add(((HugeVertex)sources.next()).id());
        }
        int sourceSize = sourceList.size();
        E.checkState((sourceSize >= 1 && sourceSize <= 10 ? 1 : 0) != 0, (String)"The number of source vertices must in [1, %s], but got: %s", (Object[])new Object[]{10, sourceList.size()});
        List<Id> targetList = TemplatePathsTraverser.newList();
        while (targets.hasNext()) {
            targetList.add(((HugeVertex)targets.next()).id());
        }
        int targetSize = targetList.size();
        E.checkState((targetSize >= 1 && targetSize <= 10 ? 1 : 0) != 0, (String)"The number of target vertices must in [1, %s], but got: %s", (Object[])new Object[]{10, sourceList.size()});
        int totalSteps = 0;
        for (RepeatEdgeStep step : steps) {
            totalSteps += step.maxTimes();
        }
        TraverseStrategy strategy = TraverseStrategy.create(totalSteps >= this.concurrentDepth(), this.graph());
        Traverser traverser = new Traverser(this, strategy, sourceList, targetList, steps, withRing, capacity, limit);
        do {
            traverser.forward();
            if (traverser.finished()) {
                return traverser.paths();
            }
            traverser.backward();
        } while (!traverser.finished());
        return traverser.paths();
    }

    private static class Traverser
    extends PathTraverser {
        protected final List<RepeatEdgeStep> steps;
        protected boolean withRing;
        protected int sourceIndex;
        protected int targetIndex;
        protected boolean sourceFinishOneStep = false;
        protected boolean targetFinishOneStep = false;

        public Traverser(HugeTraverser traverser, TraverseStrategy strategy, Collection<Id> sources, Collection<Id> targets, List<RepeatEdgeStep> steps, boolean withRing, long capacity, long limit) {
            super(traverser, strategy, sources, targets, capacity, limit);
            this.steps = steps;
            this.withRing = withRing;
            for (RepeatEdgeStep step : steps) {
                this.totalSteps += step.maxTimes();
            }
            this.sourceIndex = 0;
            this.targetIndex = this.steps.size() - 1;
            this.sourceFinishOneStep = false;
            this.targetFinishOneStep = false;
        }

        @Override
        public RepeatEdgeStep nextStep(boolean forward) {
            return forward ? this.forwardStep() : this.backwardStep();
        }

        @Override
        public void beforeTraverse(boolean forward) {
            this.clearNewVertices();
            this.reInitAllIfNeeded(forward);
        }

        @Override
        public void afterTraverse(EdgeStep step, boolean forward) {
            Map all = forward ? this.sourcesAll : this.targetsAll;
            this.addNewVerticesToAll(all);
            this.reInitCurrentStepIfNeeded(step, forward);
            ++this.stepCount;
        }

        @Override
        protected void processOneForForward(Id sourceV, Id targetV) {
            for (HugeTraverser.Node source : (List)this.sources.get(sourceV)) {
                if (!this.withRing && source.contains(targetV)) continue;
                if (this.lastSuperStep() && this.targetsAll.containsKey(targetV)) {
                    for (HugeTraverser.Node target : (List)this.targetsAll.get(targetV)) {
                        List<Id> path = HugeTraverser.joinPath(source, target, this.withRing);
                        if (path.isEmpty()) continue;
                        this.paths.add(new HugeTraverser.Path(targetV, path));
                        if (!this.reachLimit()) continue;
                        return;
                    }
                }
                this.addNodeToNewVertices(targetV, new HugeTraverser.Node(targetV, source));
            }
        }

        @Override
        protected void processOneForBackward(Id sourceV, Id targetV) {
            for (HugeTraverser.Node source : (List)this.targets.get(sourceV)) {
                if (!this.withRing && source.contains(targetV)) continue;
                if (this.lastSuperStep() && this.sourcesAll.containsKey(targetV)) {
                    for (HugeTraverser.Node target : (List)this.sourcesAll.get(targetV)) {
                        List<Id> path = HugeTraverser.joinPath(source, target, this.withRing);
                        if (path.isEmpty()) continue;
                        HugeTraverser.Path newPath = new HugeTraverser.Path(targetV, path);
                        newPath.reverse();
                        this.paths.add(newPath);
                        if (!this.reachLimit()) continue;
                        return;
                    }
                }
                this.addNodeToNewVertices(targetV, new HugeTraverser.Node(targetV, source));
            }
        }

        private void reInitAllIfNeeded(boolean forward) {
            if (forward) {
                if (this.sourceFinishOneStep && !this.lastSuperStep()) {
                    this.sourcesAll = this.newMultiValueMap();
                    this.sourceFinishOneStep = false;
                }
            } else if (this.targetFinishOneStep && !this.lastSuperStep()) {
                this.targetsAll = this.newMultiValueMap();
                this.targetFinishOneStep = false;
            }
        }

        @Override
        protected void reInitCurrentStepIfNeeded(EdgeStep step, boolean forward) {
            RepeatEdgeStep currentStep = (RepeatEdgeStep)step;
            currentStep.decreaseTimes();
            if (forward) {
                if (currentStep.remainTimes() > 0) {
                    this.sources = this.newVertices;
                } else {
                    this.sources = this.sourcesAll;
                    this.sourceFinishOneStep = true;
                }
            } else if (currentStep.remainTimes() > 0) {
                this.targets = this.newVertices;
            } else {
                this.targets = this.targetsAll;
                this.targetFinishOneStep = true;
            }
        }

        public RepeatEdgeStep forwardStep() {
            RepeatEdgeStep currentStep = null;
            for (int i = 0; i < this.steps.size(); ++i) {
                RepeatEdgeStep step = this.steps.get(i);
                if (step.remainTimes() <= 0) continue;
                currentStep = step;
                this.sourceIndex = i;
                break;
            }
            return currentStep;
        }

        public RepeatEdgeStep backwardStep() {
            RepeatEdgeStep currentStep = null;
            for (int i = this.steps.size() - 1; i >= 0; --i) {
                RepeatEdgeStep step = this.steps.get(i);
                if (step.remainTimes() <= 0) continue;
                currentStep = step;
                this.targetIndex = i;
                break;
            }
            return currentStep;
        }

        public boolean lastSuperStep() {
            return this.targetIndex == this.sourceIndex || this.targetIndex == this.sourceIndex + 1;
        }
    }
}

