/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.management.MemoryUsage;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.nodetool.Compact;
import org.apache.hugegraph.backend.store.BackendMetrics;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.cassandra.CassandraOptions;
import org.apache.hugegraph.backend.store.cassandra.CassandraSessionPool;
import org.apache.hugegraph.backend.store.cassandra.CassandraTables;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.testutil.Whitebox;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.UnitUtil;
import org.apache.tinkerpop.gremlin.util.NumberHelper;
import org.slf4j.Logger;

public class CassandraMetrics
implements BackendMetrics {
    private static final Logger LOG = Log.logger(CassandraMetrics.class);
    private final Cluster cluster;
    private final int port;
    private final String username;
    private final String password;
    private final String keyspace;
    private final List<String> tables;

    public CassandraMetrics(HugeConfig conf, CassandraSessionPool sessions, String keyspace) {
        E.checkNotNull((Object)conf, (String)"config");
        E.checkArgumentNotNull((Object)((Object)sessions), (String)"Cassandra sessions have not been initialized", (Object[])new Object[0]);
        this.cluster = sessions.cluster();
        this.port = (Integer)conf.get(CassandraOptions.CASSANDRA_JMX_PORT);
        this.username = (String)conf.get(CassandraOptions.CASSANDRA_USERNAME);
        this.password = (String)conf.get(CassandraOptions.CASSANDRA_PASSWORD);
        assert (this.username != null && this.password != null);
        this.keyspace = keyspace;
        String g = "g";
        String v = BackendTable.joinTableName((String)g, (String)CassandraTables.Vertex.TABLE);
        String oe = BackendTable.joinTableName((String)g, (String)("o" + CassandraTables.Edge.TABLE_SUFFIX));
        String ie = BackendTable.joinTableName((String)g, (String)("i" + CassandraTables.Edge.TABLE_SUFFIX));
        this.tables = ImmutableList.of((Object)v, (Object)oe, (Object)ie);
    }

    public Map<String, Object> metrics() {
        return this.executeAllHosts(this::getMetricsByHost);
    }

    protected String keyspace() {
        return this.keyspace;
    }

    protected List<String> tables() {
        return this.tables;
    }

    protected Map<String, Object> getMetricsByHost(String host) {
        Map metrics = InsertionOrderUtil.newMap();
        try (NodeProbe probe = this.newNodeProbe(host);){
            MemoryUsage heapUsage = probe.getHeapMemoryUsage();
            metrics.put("mem_max", UnitUtil.bytesToMB((long)heapUsage.getMax()));
            metrics.put("mem_committed", UnitUtil.bytesToMB((long)heapUsage.getCommitted()));
            metrics.put("mem_used", UnitUtil.bytesToMB((long)heapUsage.getUsed()));
            metrics.put("mem_used_readable", UnitUtil.bytesToReadableString((long)heapUsage.getUsed()));
            metrics.put("mem_unit", "MB");
            long diskSize = UnitUtil.bytesFromReadableString((String)probe.getLoadString());
            metrics.put("disk_usage", UnitUtil.bytesToGB((long)diskSize));
            metrics.put("disk_usage_readable", UnitUtil.bytesToReadableString((long)diskSize));
            metrics.put("disk_usage_details", probe.getLoadMap());
            metrics.put("disk_unit", "GB");
            metrics.put("uptime", probe.getUptime());
            metrics.put("uptime_readable", UnitUtil.timestampToReadableString((long)probe.getUptime()));
            metrics.put("time_unit", "ms");
            this.appendExtraMetrics(metrics, probe);
            metrics.put("live_nodes", probe.getLiveNodes());
            metrics.put("joining_nodes", probe.getJoiningNodes());
            metrics.put("moving_nodes", probe.getMovingNodes());
            metrics.put("leaving_nodes", probe.getLeavingNodes());
            metrics.put("unreachable_nodes", probe.getUnreachableNodes());
            metrics.put("keyspaces", probe.getKeyspaces());
            metrics.put("num_tables", probe.getNumberOfTables());
            metrics.put("exception_count", probe.getExceptionCount());
        }
        catch (Throwable e) {
            LOG.debug("Unable to get metrics from host '{}':", (Object)host, (Object)e);
            metrics.put("exception", e.toString());
        }
        return metrics;
    }

    protected void appendExtraMetrics(Map<String, Object> metrics, NodeProbe probe) {
        CassandraMetrics.appendCounterMetrics(metrics, probe, this.keyspace, this.tables, "EstimatedPartitionCount");
        CassandraMetrics.appendCounterMetrics(metrics, probe, this.keyspace, this.tables, "DroppedMutations");
        CassandraMetrics.appendCounterMetrics(metrics, probe, this.keyspace, this.tables, "PendingFlushes");
        CassandraMetrics.appendCounterMetrics(metrics, probe, this.keyspace, this.tables, "KeyCacheHitRate");
        CassandraMetrics.appendCounterMetrics(metrics, probe, this.keyspace, this.tables, "BloomFilterFalseRatio");
        CassandraMetrics.appendTimerMetrics(metrics, probe, this.keyspace, "WriteLatency");
        CassandraMetrics.appendTimerMetrics(metrics, probe, this.keyspace, "ReadLatency");
        CassandraMetrics.appendTimerMetrics(metrics, probe, null, "WriteLatency");
        CassandraMetrics.appendTimerMetrics(metrics, probe, null, "ReadLatency");
        CassandraMetrics.appendCacheMetrics(metrics, probe, "KeyCache", "Size");
        CassandraMetrics.appendCacheMetrics(metrics, probe, "KeyCache", "Entries");
        CassandraMetrics.appendCacheMetrics(metrics, probe, "RowCache", "Size");
        CassandraMetrics.appendCacheMetrics(metrics, probe, "RowCache", "Entries");
        CassandraMetrics.appendCacheMetrics(metrics, probe, "CounterCache", "Size");
        CassandraMetrics.appendCacheMetrics(metrics, probe, "CounterCache", "Entries");
        CassandraMetrics.appendCompactionMetrics(metrics, probe, "CompletedTasks");
        CassandraMetrics.appendCompactionMetrics(metrics, probe, "PendingTasks");
        CassandraMetrics.appendCompactionMetrics(metrics, probe, "BytesCompacted");
    }

    protected static void appendCounterMetrics(Map<String, Object> metrics, NodeProbe probe, String keyspace, List<String> tables, String metric) {
        String name = CassandraMetrics.humpToLine(metric);
        Number number = 0;
        for (String table : tables) {
            Object value = probe.getColumnFamilyMetric(keyspace, table, metric);
            if (!(value instanceof Number)) {
                value = Double.parseDouble(value.toString());
            }
            number = NumberHelper.add((Number)number, (Number)((Number)value));
        }
        metrics.put(name, number);
    }

    protected static void appendTimerMetrics(Map<String, Object> metrics, NodeProbe probe, String keyspace, String metric) {
        String suffix = keyspace == null ? "*" : keyspace;
        String name = CassandraMetrics.humpToLine(metric + "_" + suffix);
        CassandraMetricsRegistry.JmxTimerMBean value = (CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspace, null, metric);
        Map timerMap = InsertionOrderUtil.newMap();
        timerMap.put("count", value.getCount());
        timerMap.put("min", value.getMin());
        timerMap.put("mean", value.getMean());
        timerMap.put("max", value.getMax());
        timerMap.put("stddev", value.getStdDev());
        timerMap.put("p50", value.get50thPercentile());
        timerMap.put("p75", value.get75thPercentile());
        timerMap.put("p95", value.get95thPercentile());
        timerMap.put("p98", value.get98thPercentile());
        timerMap.put("p99", value.get99thPercentile());
        timerMap.put("p999", value.get999thPercentile());
        timerMap.put("duration_unit", value.getDurationUnit());
        timerMap.put("mean_rate", value.getMeanRate());
        timerMap.put("m15_rate", value.getFifteenMinuteRate());
        timerMap.put("m5_rate", value.getFiveMinuteRate());
        timerMap.put("m1_rate", value.getOneMinuteRate());
        timerMap.put("rate_unit", value.getRateUnit());
        metrics.put(name, timerMap);
    }

    protected static void appendCompactionMetrics(Map<String, Object> metrics, NodeProbe probe, String metric) {
        String name = CassandraMetrics.humpToLine("compaction" + metric);
        Object value = probe.getCompactionMetric(metric);
        if (value instanceof CassandraMetricsRegistry.JmxCounterMBean) {
            value = ((CassandraMetricsRegistry.JmxCounterMBean)value).getCount();
        }
        metrics.put(name, value);
    }

    protected static void appendCacheMetrics(Map<String, Object> metrics, NodeProbe probe, String cacheType, String metric) {
        String name = CassandraMetrics.humpToLine(cacheType + metric);
        metrics.put(name, probe.getCacheMetric(cacheType, metric));
    }

    private static String humpToLine(String name) {
        if (!(name = name.replaceAll("[A-Z]", "_$0").toLowerCase()).isEmpty() && name.charAt(0) == '_') {
            name = name.substring(1);
        }
        return name;
    }

    public Map<String, Object> compact() {
        return this.executeAllHosts(this::compactHost);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object compactHost(String host) {
        try (NodeProbe probe = this.newNodeProbe(host);){
            Compact compact = new Compact();
            Whitebox.invoke((Object)compact, (String)"args", (Class[])new Class[]{Object.class}, (String)"add", (Object[])new Object[]{this.keyspace});
            compact.execute(probe);
            String string = "OK";
            return string;
        }
        catch (Throwable e) {
            return e.toString();
        }
    }

    private Map<String, Object> executeAllHosts(Function<String, Object> func) {
        Set hosts = this.cluster.getMetadata().getAllHosts();
        Map results = InsertionOrderUtil.newMap();
        results.put("cluster_id", this.cluster.getClusterName());
        results.put("nodes", hosts.size());
        Map hostsResults = InsertionOrderUtil.newMap();
        for (Host host : hosts) {
            String hostAddress;
            InetAddress address = host.getAddress();
            if (address instanceof Inet4Address) {
                hostAddress = host.getAddress().getHostAddress();
                hostAddress = "::FFFF:" + hostAddress;
            } else {
                assert (address instanceof Inet6Address);
                hostAddress = host.getAddress().getHostAddress();
            }
            hostsResults.put(hostAddress, func.apply(hostAddress));
        }
        results.put("servers", hostsResults);
        return results;
    }

    private NodeProbe newNodeProbe(String host) throws IOException {
        LOG.debug("Probe to cassandra node: '{}:{}'", (Object)host, (Object)this.port);
        return this.username.isEmpty() ? new NodeProbe(host, this.port) : new NodeProbe(host, this.port, this.username, this.password);
    }
}

