/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.cassandra;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TokenRange;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.OrderPreservingPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.Shard;
import org.apache.hugegraph.backend.store.cassandra.CassandraSessionPool;

public class CassandraShard {
    private static final int MIN_SHARD_SIZE = 0x100000;
    private CassandraSessionPool.Session session;
    private String keyspace;
    private String table;
    private IPartitioner partitioner;

    public CassandraShard(CassandraSessionPool.Session session, String keyspace, String table) {
        this.session = session;
        this.keyspace = keyspace;
        this.table = table;
        this.partitioner = new Murmur3Partitioner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Shard> getSplits(long splitPartitions, long splitSize) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 128, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        ArrayList<Shard> splits = new ArrayList<Shard>();
        try {
            ArrayList<Future<List<Shard>>> futures = new ArrayList<Future<List<Shard>>>();
            Map<TokenRange, Set<Host>> masterRangeNodes = this.getRangeMap();
            for (TokenRange tokenRange : masterRangeNodes.keySet()) {
                futures.add(executor.submit(new SplitCallable(tokenRange, splitPartitions, splitSize)));
            }
            for (Future future : futures) {
                try {
                    splits.addAll((Collection)future.get());
                }
                catch (Exception e) {
                    throw new BackendException("Can't get cassandra shards", (Throwable)e);
                }
            }
            assert (splits.size() > masterRangeNodes.size());
        }
        finally {
            executor.shutdownNow();
        }
        Collections.shuffle(splits, new Random(System.nanoTime()));
        return splits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Shard> getSplits(String start, String end, int splitPartitions, int splitSize) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 128, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        ArrayList<Shard> splits = new ArrayList<Shard>();
        try {
            ArrayList<Future<List<Shard>>> futures = new ArrayList<Future<List<Shard>>>();
            Token.TokenFactory tokenFactory = this.partitioner.getTokenFactory();
            TokenRange tokenRange = this.rangeToTokenRange((Range<Token>)new Range((RingPosition)tokenFactory.fromString(start), (RingPosition)tokenFactory.fromString(end)));
            Map<TokenRange, Set<Host>> masterRangeNodes = this.getRangeMap();
            for (TokenRange tokenRange2 : masterRangeNodes.keySet()) {
                for (TokenRange r : tokenRange2.intersectWith(tokenRange)) {
                    futures.add(executor.submit(new SplitCallable(r, splitPartitions, splitSize)));
                }
            }
            for (Future future : futures) {
                try {
                    splits.addAll((Collection)future.get());
                }
                catch (Exception e) {
                    throw new BackendException("Can't get cassandra shards", (Throwable)e);
                }
            }
            assert (splits.size() >= masterRangeNodes.size());
        }
        finally {
            executor.shutdownNow();
        }
        Collections.shuffle(splits, new Random(System.nanoTime()));
        return splits;
    }

    private boolean isPartitionerOpp() {
        return this.partitioner instanceof OrderPreservingPartitioner || this.partitioner instanceof ByteOrderedPartitioner;
    }

    private TokenRange rangeToTokenRange(Range<Token> range) {
        Token.TokenFactory tokenFactory = this.partitioner.getTokenFactory();
        Metadata metadata = this.session.metadata();
        return metadata.newTokenRange(metadata.newToken(tokenFactory.toString((Token)range.left)), metadata.newToken(tokenFactory.toString((Token)range.right)));
    }

    private Map<TokenRange, Long> getSubSplits(TokenRange tokenRange, long splitPartitions, long splitSize) {
        try {
            return CassandraShard.describeSplits(this.session, this.keyspace, this.table, splitPartitions, splitSize, tokenRange);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<TokenRange, Set<Host>> getRangeMap() {
        Metadata metadata = this.session.metadata();
        return metadata.getTokenRanges().stream().collect(Collectors.toMap(p -> p, p -> metadata.getReplicas('\"' + this.keyspace + '\"', p)));
    }

    private static Map<TokenRange, Long> describeSplits(CassandraSessionPool.Session session, String keyspace, String table, long splitPartitions, long splitSize, TokenRange tokenRange) {
        String query = String.format("SELECT mean_partition_size, partitions_count FROM %s.%s WHERE keyspace_name = ? AND table_name = ? AND range_start = ? AND range_end = ?", "system", "size_estimates");
        ResultSet resultSet = session.execute(query, keyspace, table, tokenRange.getStart().toString(), tokenRange.getEnd().toString());
        Row row = resultSet.one();
        long meanPartitionSize = 0L;
        long partitionsCount = 0L;
        long splitCount = 0L;
        if (row != null) {
            meanPartitionSize = row.getLong("mean_partition_size");
            partitionsCount = row.getLong("partitions_count");
            assert (splitSize <= 0L || splitSize >= 0x100000L);
            long l = splitCount = splitSize > 0L ? meanPartitionSize * partitionsCount / splitSize : partitionsCount / splitPartitions;
        }
        if (splitCount == 0L) {
            return ImmutableMap.of((Object)tokenRange, (Object)128L);
        }
        List ranges = tokenRange.splitEvenly((int)splitCount);
        HashMap<TokenRange, Long> rangesWithLength = new HashMap<TokenRange, Long>();
        for (TokenRange range : ranges) {
            rangesWithLength.put(range, partitionsCount / splitCount);
        }
        return rangesWithLength;
    }

    class SplitCallable
    implements Callable<List<Shard>> {
        private final TokenRange tokenRange;
        private final long splitPartitions;
        private final long splitSize;

        public SplitCallable(TokenRange tokenRange, long splitPartitions, long splitSize) {
            if (splitSize <= 0L && splitPartitions <= 0L) {
                throw new IllegalArgumentException(String.format("The split-partitions must be > 0, but got %s", splitPartitions));
            }
            if (splitSize > 0L && splitSize < 0x100000L) {
                throw new IllegalArgumentException(String.format("The split-size must be >= %s bytes, but got %s", 0x100000, splitSize));
            }
            this.tokenRange = tokenRange;
            this.splitPartitions = splitPartitions;
            this.splitSize = splitSize;
        }

        @Override
        public List<Shard> call() throws Exception {
            ArrayList<Shard> splits = new ArrayList<Shard>();
            Map subSplits = CassandraShard.this.getSubSplits(this.tokenRange, this.splitPartitions, this.splitSize);
            for (Map.Entry entry : subSplits.entrySet()) {
                List ranges = ((TokenRange)entry.getKey()).unwrap();
                for (TokenRange subrange : ranges) {
                    String start = !CassandraShard.this.isPartitionerOpp() ? subrange.getStart().toString() : subrange.getStart().toString().substring(2);
                    String end = !CassandraShard.this.isPartitionerOpp() ? subrange.getEnd().toString() : subrange.getEnd().toString().substring(2);
                    long length = (Long)entry.getValue();
                    splits.add(new Shard(start, end, length));
                }
            }
            return splits;
        }
    }
}

