/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.finger;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nlpcn.commons.lang.finger.AbsService;
import org.nlpcn.commons.lang.tire.GetWord;
import org.nlpcn.commons.lang.util.MurmurHash;

public class SimHashService
extends AbsService {
    private static final int BYTE_LEN = 64;
    private static final long[] BITS = new long[64];

    public int hmDistance(long a, long b) {
        return Long.bitCount(a ^ b);
    }

    public int hmDistance(String c1, String c2) {
        return this.hmDistance(this.fingerprint(c1), this.fingerprint(c2));
    }

    public long fingerprint(String content) {
        int[] values = new int[64];
        for (String word : this.analysis(content)) {
            long hashCode = this.hash(word);
            for (int i = 0; i < 64; ++i) {
                if ((hashCode & BITS[i]) != 0L) {
                    int n = 63 - i;
                    values[n] = values[n] + 1;
                    continue;
                }
                int n = 63 - i;
                values[n] = values[n] - 1;
            }
        }
        long result = 0L;
        for (int i = 0; i < 64; ++i) {
            if (values[i] <= 0) continue;
            result |= BITS[63 - i];
        }
        return result;
    }

    public List<String> analysis(String content) {
        GetWord word = forest.getWord(content);
        String temp = null;
        ArrayList<String> all = new ArrayList<String>();
        while ((temp = word.getFrontWords()) != null) {
            all.add(temp);
        }
        return all;
    }

    public long hash(String word) {
        return MurmurHash.hash64(word);
    }

    public Index createIndex() {
        return new Index();
    }

    static {
        SimHashService.BITS[0] = 1L;
        for (int i = 1; i < BITS.length; ++i) {
            SimHashService.BITS[i] = BITS[i - 1] * 2L;
        }
    }

    public class Index {
        List<Long>[] lists = new List[2048];

        private Index() {
        }

        public void addHashCode(long hash) {
            int[] indexs = this.makeCodeIndex(hash);
            for (int i = 0; i < indexs.length; ++i) {
                int idx = indexs[i];
                if (this.lists[idx] == null) {
                    this.lists[idx] = new ArrayList<Long>();
                }
                this.lists[idx].add(hash);
            }
        }

        private int[] makeCodeIndex(long hashCode) {
            return new int[]{(int)(hashCode & BITS[8] - 1L), (int)(hashCode >>> 8 & BITS[8] - 1L + 256L), (int)(hashCode >>> 16 & BITS[8] - 1L + 512L), (int)(hashCode >>> 24 & BITS[8] - 1L + 768L), (int)(hashCode >>> 32 & BITS[8] - 1L + 1024L), (int)(hashCode >>> 40 & BITS[8] - 1L + 1280L), (int)(hashCode >>> 48 & BITS[8] - 1L + 1536L), (int)(hashCode >>> 56 & BITS[8] - 1L + 1792L)};
        }

        public void add(String content) {
            this.addHashCode(SimHashService.this.fingerprint(content));
        }

        public int nearest(long hashCode) {
            int[] indexs = this.makeCodeIndex(hashCode);
            int hmDistance = 64;
            for (int i = 0; i < indexs.length; ++i) {
                List<Long> list = this.lists[indexs[i]];
                if (list == null) continue;
                for (Long hc : list) {
                    hmDistance = Math.min(SimHashService.this.hmDistance(hashCode, hc), hmDistance);
                }
                if (hmDistance != 0) continue;
                return hmDistance;
            }
            return hmDistance;
        }

        public int nearest(String content) {
            return this.nearest(SimHashService.this.fingerprint(content));
        }

        public int nearestAndAdd(long hashCode) {
            int hmDistance = this.nearest(hashCode);
            if (hmDistance > 0) {
                this.addHashCode(hashCode);
            }
            return hmDistance;
        }

        public int nearestAndAdd(String content) {
            return this.nearestAndAdd(SimHashService.this.fingerprint(content));
        }

        public Set<Long> allHashCode() {
            HashSet<Long> hs = new HashSet<Long>();
            for (List<Long> list : this.lists) {
                if (list == null) continue;
                for (Long i : list) {
                    hs.add(i);
                }
            }
            return hs;
        }
    }
}

