/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Command;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="describecluster", description="Print the name, snitch, partitioner and schema version of a cluster")
public class DescribeCluster
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        out.println("Cluster Information:");
        out.println("\tName: " + probe.getClusterName());
        String snitch = probe.getEndpointSnitchInfoProxy().getSnitchName();
        boolean dynamicSnitchEnabled = false;
        if (snitch.equals(DynamicEndpointSnitch.class.getName())) {
            snitch = probe.getDynamicEndpointSnitchInfoProxy().getSubsnitchClassName();
            dynamicSnitchEnabled = true;
        }
        out.println("\tSnitch: " + snitch);
        out.println("\tDynamicEndPointSnitch: " + (dynamicSnitchEnabled ? "enabled" : "disabled"));
        out.println("\tPartitioner: " + probe.getPartitioner());
        out.println("\tSchema versions:");
        Map<String, List<String>> schemaVersions = probe.getSpProxy().getSchemaVersions();
        for (String version : schemaVersions.keySet()) {
            out.println(String.format("\t\t%s: %s%n", version, schemaVersions.get(version)));
        }
    }
}

