/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.zk;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.codec.common.StringSerializer;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import com.alipay.sofa.rpc.registry.zk.ZookeeperRegistryHelper;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.recipes.cache.ChildData;

public class ZookeeperProviderObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperProviderObserver.class);
    private ConcurrentMap<ConsumerConfig, List<ProviderInfoListener>> providerListenerMap = new ConcurrentHashMap<ConsumerConfig, List<ProviderInfoListener>>();

    public void addProviderListener(ConsumerConfig consumerConfig, ProviderInfoListener listener) {
        if (listener != null) {
            RegistryUtils.initOrAddList(this.providerListenerMap, consumerConfig, listener);
        }
    }

    public void removeProviderListener(ConsumerConfig consumerConfig) {
        this.providerListenerMap.remove(consumerConfig);
    }

    public void updateProvider(ConsumerConfig config, String providerPath, ChildData data, List<ChildData> currentData) throws UnsupportedEncodingException {
        if (LOGGER.isInfoEnabled(config.getAppName())) {
            LOGGER.infoWithApp(config.getAppName(), "Receive update provider: path=[" + data.getPath() + "], data=[" + StringSerializer.decode(data.getData()) + "], stat=[" + data.getStat() + "], list=[" + currentData.size() + "]");
        }
        this.notifyListeners(config, providerPath, currentData, false);
    }

    public void removeProvider(ConsumerConfig config, String providerPath, ChildData data, List<ChildData> currentData) throws UnsupportedEncodingException {
        if (LOGGER.isInfoEnabled(config.getAppName())) {
            LOGGER.infoWithApp(config.getAppName(), "Receive remove provider: path=[" + data.getPath() + "], data=[" + StringSerializer.decode(data.getData()) + "], stat=[" + data.getStat() + "], list=[" + currentData.size() + "]");
        }
        this.notifyListeners(config, providerPath, currentData, false);
    }

    public void addProvider(ConsumerConfig config, String providerPath, ChildData data, List<ChildData> currentData) throws UnsupportedEncodingException {
        if (LOGGER.isInfoEnabled(config.getAppName())) {
            LOGGER.infoWithApp(config.getAppName(), "Receive add provider: path=[" + data.getPath() + "], data=[" + StringSerializer.decode(data.getData()) + "], stat=[" + data.getStat() + "], list=[" + currentData.size() + "]");
        }
        this.notifyListeners(config, providerPath, currentData, true);
    }

    private void notifyListeners(ConsumerConfig config, String providerPath, List<ChildData> currentData, boolean add) throws UnsupportedEncodingException {
        List providerInfoListeners = (List)this.providerListenerMap.get(config);
        if (CommonUtils.isNotEmpty(providerInfoListeners)) {
            List<ProviderInfo> providerInfos = ZookeeperRegistryHelper.convertUrlsToProviders(providerPath, currentData);
            List<ProviderInfo> providerInfosForProtocol = RegistryUtils.matchProviderInfos(config, providerInfos);
            for (ProviderInfoListener listener : providerInfoListeners) {
                if (add) {
                    listener.addProvider(new ProviderGroup(providerInfosForProtocol));
                    continue;
                }
                listener.updateProviders(new ProviderGroup(providerInfosForProtocol));
            }
        }
    }
}

