/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.gremlin;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import org.apache.hugegraph.api.filter.CompressInterceptor;
import org.apache.hugegraph.api.gremlin.GremlinQueryAPI;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.opencypher.gremlin.translation.TranslationFacade;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/cypher")
@Singleton
@Tag(name="CypherAPI")
public class CypherAPI
extends GremlinQueryAPI {
    private static final Logger LOG = Log.logger(CypherAPI.class);

    @GET
    @Timed
    @CompressInterceptor.Compress(buffer=40960)
    @Produces(value={"application/json;charset=UTF-8"})
    public Response query(@PathParam(value="graph") String graph, @Context HttpHeaders headers, @QueryParam(value="cypher") String cypher) {
        LOG.debug("Graph [{}] query by cypher: {}", (Object)graph, (Object)cypher);
        return this.queryByCypher(graph, headers, cypher);
    }

    @POST
    @Timed
    @CompressInterceptor.Compress
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response post(@PathParam(value="graph") String graph, @Context HttpHeaders headers, String cypher) {
        LOG.debug("Graph [{}] query by cypher: {}", (Object)graph, (Object)cypher);
        return this.queryByCypher(graph, headers, cypher);
    }

    private Response queryByCypher(String graph, HttpHeaders headers, String cypher) {
        E.checkArgument((cypher != null && !cypher.isEmpty() ? 1 : 0) != 0, (String)"The cypher parameter can't be null or empty", (Object[])new Object[0]);
        String gremlin = this.translateCpyher2Gremlin(graph, cypher);
        LOG.debug("translated gremlin is {}", (Object)gremlin);
        String auth = headers.getHeaderString("Authorization");
        String request = "{\"gremlin\":\"" + gremlin + "\",\"bindings\":{},\"language\":\"gremlin-groovy\",\"aliases\":{\"g\":\"__g_" + graph + "\"}}";
        Response response = this.client().doPostRequest(auth, request);
        return CypherAPI.transformResponseIfNeeded(response);
    }

    private String translateCpyher2Gremlin(String graph, String cypher) {
        TranslationFacade translator = new TranslationFacade();
        String gremlin = translator.toGremlinGroovy(cypher);
        gremlin = this.buildQueryableGremlin(graph, gremlin);
        return gremlin;
    }

    private String buildQueryableGremlin(String graph, String gremlin) {
        gremlin = gremlin.replace(".property(single,", ".property(");
        return gremlin;
    }
}

