/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.PathsTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/crosspoints")
@Singleton
@Tag(name="CrosspointsAPI")
public class CrosspointsAPI
extends API {
    private static final Logger LOG = Log.logger(CrosspointsAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="source") String source, @QueryParam(value="target") String target, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_depth") int depth, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="capacity") @DefaultValue(value="10000000") long capacity, @QueryParam(value="limit") @DefaultValue(value="10") int limit) {
        LOG.debug("Graph [{}] get crosspoints with paths from '{}', to '{}' with direction '{}', edge label '{}', max depth '{}', max degree '{}', capacity '{}' and limit '{}'", new Object[]{graph, source, target, direction, edgeLabel, depth, maxDegree, capacity, limit});
        Id sourceId = VertexAPI.checkAndParseVertexId(source);
        Id targetId = VertexAPI.checkAndParseVertexId(target);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = CrosspointsAPI.graph(manager, graph);
        PathsTraverser traverser = new PathsTraverser(g);
        HugeTraverser.PathSet paths = traverser.paths(sourceId, dir, targetId, dir, edgeLabel, depth, maxDegree, capacity, (long)limit);
        return manager.serializer((Graph)g).writePaths("crosspoints", (Collection<HugeTraverser.Path>)paths, true);
    }
}

