/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.traversers.TraverserAPI;
import org.apache.hugegraph.api.traversers.Vertices;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.TemplatePathsTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.RepeatEdgeStep;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/templatepaths")
@Singleton
@Tag(name="TemplatePathsAPI")
public class TemplatePathsAPI
extends TraverserAPI {
    private static final Logger LOG = Log.logger(TemplatePathsAPI.class);

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graph") String graph, Request request) {
        E.checkArgumentNotNull((Object)request, (String)"The request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.sources, (String)"The sources of request can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.targets, (String)"The targets of request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.steps != null && !request.steps.isEmpty() ? 1 : 0) != 0, (String)"The steps of request can't be empty", (Object[])new Object[0]);
        LOG.debug("Graph [{}] get template paths from source vertices '{}', target vertices '{}', with steps '{}', capacity '{}', limit '{}' and with_vertex '{}'", new Object[]{graph, request.sources, request.targets, request.steps, request.capacity, request.limit, request.withVertex});
        HugeGraph g = TemplatePathsAPI.graph(manager, graph);
        Iterator<Vertex> sources = request.sources.vertices(g);
        Iterator<Vertex> targets = request.targets.vertices(g);
        List<RepeatEdgeStep> steps = TemplatePathsAPI.steps(g, request.steps);
        TemplatePathsTraverser traverser = new TemplatePathsTraverser(g);
        Set paths = traverser.templatePaths(sources, targets, steps, request.withRing, request.capacity, (long)request.limit);
        if (!request.withVertex) {
            return manager.serializer((Graph)g).writePaths("paths", paths, false);
        }
        HashSet ids = new HashSet();
        for (HugeTraverser.Path p : paths) {
            ids.addAll(p.vertices());
        }
        Iterator iter = QueryResults.emptyIterator();
        if (!ids.isEmpty()) {
            iter = g.vertices(ids.toArray());
        }
        return manager.serializer((Graph)g).writePaths("paths", paths, false, iter);
    }

    private static List<RepeatEdgeStep> steps(HugeGraph g, List<TemplatePathStep> steps) {
        ArrayList<RepeatEdgeStep> edgeSteps = new ArrayList<RepeatEdgeStep>(steps.size());
        for (TemplatePathStep step : steps) {
            edgeSteps.add(TemplatePathsAPI.repeatEdgeStep(g, step));
        }
        return edgeSteps;
    }

    private static RepeatEdgeStep repeatEdgeStep(HugeGraph graph, TemplatePathStep step) {
        return new RepeatEdgeStep(graph, step.direction, step.labels, step.properties, step.maxDegree, step.skipDegree, step.maxTimes);
    }

    protected static class TemplatePathStep
    extends TraverserAPI.Step {
        @JsonProperty(value="max_times")
        public int maxTimes = 1;

        protected TemplatePathStep() {
        }

        @Override
        public String toString() {
            return String.format("TemplatePathStep{direction=%s,labels=%s,properties=%s,maxDegree=%s,skipDegree=%s,maxTimes=%s}", this.direction, this.labels, this.properties, this.maxDegree, this.skipDegree, this.maxTimes);
        }
    }

    private static class Request {
        @JsonProperty(value="sources")
        public Vertices sources;
        @JsonProperty(value="targets")
        public Vertices targets;
        @JsonProperty(value="steps")
        public List<TemplatePathStep> steps;
        @JsonProperty(value="with_ring")
        public boolean withRing = false;
        @JsonProperty(value="capacity")
        public long capacity = Long.parseLong("10000000");
        @JsonProperty(value="limit")
        public int limit = Integer.parseInt("10");
        @JsonProperty(value="with_vertex")
        public boolean withVertex = false;

        private Request() {
        }

        public String toString() {
            return String.format("TemplatePathsRequest{sources=%s,targets=%s,steps=%s,withRing=%s,capacity=%s,limit=%s,withVertex=%s}", this.sources, this.targets, this.steps, this.withRing, this.capacity, this.limit, this.withVertex);
        }
    }
}

