/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.ShortestPathTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/shortestpath")
@Singleton
@Tag(name="ShortestPathAPI")
public class ShortestPathAPI
extends API {
    private static final Logger LOG = Log.logger(ShortestPathAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="source") String source, @QueryParam(value="target") String target, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_depth") int depth, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="skip_degree") @DefaultValue(value="0") long skipDegree, @QueryParam(value="with_vertex") @DefaultValue(value="false") boolean withVertex, @QueryParam(value="with_edge") @DefaultValue(value="false") boolean withEdge, @QueryParam(value="capacity") @DefaultValue(value="10000000") long capacity) {
        Iterator iterVertex;
        LOG.debug("Graph [{}] get shortest path from '{}', to '{}' with direction {}, edge label {}, max depth '{}', max degree '{}', skipped maxDegree '{}', capacity '{}', with_vertex '{}' and with_edge '{}'", new Object[]{graph, source, target, direction, edgeLabel, depth, maxDegree, skipDegree, capacity, withVertex, withEdge});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        Id sourceId = VertexAPI.checkAndParseVertexId(source);
        Id targetId = VertexAPI.checkAndParseVertexId(target);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = ShortestPathAPI.graph(manager, graph);
        ShortestPathTraverser traverser = new ShortestPathTraverser(g);
        ImmutableList edgeLabels = edgeLabel == null ? ImmutableList.of() : ImmutableList.of((Object)edgeLabel);
        HugeTraverser.Path path = traverser.shortestPath(sourceId, targetId, dir, (List)edgeLabels, depth, maxDegree, skipDegree, capacity);
        measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        List vertexIds = path.vertices();
        if (withVertex && !vertexIds.isEmpty()) {
            iterVertex = g.vertices(vertexIds.toArray());
            measure.addIterCount(path.vertices().size(), 0L);
        } else {
            iterVertex = vertexIds.iterator();
        }
        Set edges = path.getEdges();
        Iterator iterEdge = withEdge ? edges.iterator() : HugeTraverser.EdgeRecord.getEdgeIds((Set)edges).iterator();
        return manager.serializer((Graph)g, measure.measures()).writeMap((Map<?, ?>)ImmutableMap.of((Object)"path", (Object)path.vertices(), (Object)"vertices", (Object)iterVertex, (Object)"edges", iterEdge));
    }
}

