/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import org.jetbrains.annotations.NotNull;

public class URIEncoder {
    private static final String mark = "-_.!~*'()\"";
    private static final char[] hex = "0123456789ABCDEF".toCharArray();

    public static String encodeURI(@NotNull String argString) {
        @NotNull StringBuilder uri = new StringBuilder();
        for (char c : argString.toCharArray()) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || mark.indexOf(c) != -1) {
                uri.append(c);
                continue;
            }
            URIEncoder.appendEscaped(uri, c);
        }
        return uri.toString();
    }

    private static void appendEscaped(@NotNull StringBuilder uri, char c) {
        if (c <= '\u00ff') {
            uri.append("%");
            uri.append(hex[c >> 4 & 0xF]);
            uri.append(hex[c & 0xF]);
            return;
        }
        uri.append('\\');
        uri.append('u');
        uri.append(hex[c >> 12 & 0xF]);
        uri.append(hex[c >> 8 & 0xF]);
        uri.append(hex[c >> 4 & 0xF]);
        uri.append(hex[c & 0xF]);
    }
}

