/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.serializer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.serializer.AbstractSerializer;
import org.apache.hugegraph.backend.serializer.BinaryScatterSerializer;
import org.apache.hugegraph.backend.serializer.BinarySerializer;
import org.apache.hugegraph.backend.serializer.TextSerializer;
import org.apache.hugegraph.config.HugeConfig;

public class SerializerFactory {
    private static final Map<String, Class<? extends AbstractSerializer>> serializers = new ConcurrentHashMap<String, Class<? extends AbstractSerializer>>();

    public static AbstractSerializer serializer(HugeConfig config, String name) {
        switch (name = name.toLowerCase()) {
            case "binary": {
                return new BinarySerializer(config);
            }
            case "binaryscatter": {
                return new BinaryScatterSerializer(config);
            }
            case "text": {
                return new TextSerializer(config);
            }
        }
        Class<? extends AbstractSerializer> clazz = serializers.get(name);
        if (clazz == null) {
            throw new BackendException("Not exists serializer: '%s'", name);
        }
        assert (AbstractSerializer.class.isAssignableFrom(clazz));
        try {
            return clazz.getConstructor(HugeConfig.class).newInstance(config);
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
    }

    public static void register(String name, String classPath) {
        Class<?> clazz;
        ClassLoader classLoader = SerializerFactory.class.getClassLoader();
        try {
            clazz = classLoader.loadClass(classPath);
        }
        catch (Exception e) {
            throw new BackendException("Invalid class: '%s'", (Throwable)e, classPath);
        }
        if (!AbstractSerializer.class.isAssignableFrom(clazz)) {
            throw new BackendException("Class is not a subclass of class AbstractSerializer: '%s'", classPath);
        }
        if (serializers.containsKey(name)) {
            throw new BackendException("Exists serializer: %s(Class '%s')", name, serializers.get(name).getName());
        }
        serializers.put(name, clazz);
    }
}

