/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Set;
import java.util.function.Consumer;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.OltpTraverser;
import org.apache.hugegraph.traversal.algorithm.records.KneighborRecords;
import org.apache.hugegraph.traversal.algorithm.steps.Steps;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class KneighborTraverser
extends OltpTraverser {
    public KneighborTraverser(HugeGraph graph) {
        super(graph);
    }

    public Set<Id> kneighbor(Id sourceV, Directions dir, String label, int depth, long degree, long limit) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        KneighborTraverser.checkPositive(depth, "k-neighbor max_depth");
        KneighborTraverser.checkDegree(degree);
        KneighborTraverser.checkLimit(limit);
        Id labelId = this.getEdgeLabelId(label);
        KneighborRecords records = new KneighborRecords(true, sourceV, true);
        Consumer<EdgeId> consumer = edgeId -> {
            if (this.reachLimit(limit, records.size())) {
                return;
            }
            records.addPath(edgeId.ownerVertexId(), edgeId.otherVertexId());
        };
        while (depth-- > 0) {
            records.startOneLayer(true);
            this.traverseIdsByBfs(records.keys(), dir, labelId, degree, -1L, consumer);
            records.finishOneLayer();
            if (!this.reachLimit(limit, records.size())) continue;
        }
        this.vertexIterCounter.addAndGet(records.size());
        return records.idsBySet(limit);
    }

    public KneighborRecords customizedKneighbor(Id source, Steps steps, int maxDepth, long limit) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        KneighborTraverser.checkPositive(maxDepth, "k-neighbor max_depth");
        KneighborTraverser.checkLimit(limit);
        KneighborRecords records = new KneighborRecords(true, source, true);
        Consumer<Edge> consumer = edge -> {
            if (this.reachLimit(limit, records.size())) {
                return;
            }
            EdgeId edgeId = ((HugeEdge)edge).id();
            records.addPath(edgeId.ownerVertexId(), edgeId.otherVertexId());
            records.edgeResults().addEdge(edgeId.ownerVertexId(), edgeId.otherVertexId(), (Edge)edge);
        };
        while (maxDepth-- > 0) {
            records.startOneLayer(true);
            this.traverseIdsByBfs(records.keys(), steps, -1L, consumer);
            records.finishOneLayer();
            if (!this.reachLimit(limit, records.size())) continue;
        }
        this.vertexIterCounter.addAndGet(records.size());
        return records;
    }

    private boolean reachLimit(long limit, int size) {
        return limit != -1L && (long)size >= limit;
    }
}

