/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.records;

import java.util.function.Function;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.records.DoubleWayMultiPathsRecords;
import org.apache.hugegraph.traversal.algorithm.records.record.RecordType;

public class PathsRecords
extends DoubleWayMultiPathsRecords {
    public PathsRecords(boolean concurrent, Id sourceV, Id targetV) {
        super(RecordType.ARRAY, concurrent, sourceV, targetV);
    }

    @Override
    @PerfUtil.Watched
    public HugeTraverser.PathSet findPath(Id target, Function<Id, Boolean> filter, boolean all, boolean ring) {
        assert (all);
        int targetCode = this.code(target);
        int parentCode = this.current();
        HugeTraverser.PathSet paths = HugeTraverser.PathSet.EMPTY;
        if (this.parentsContain(targetCode)) {
            return paths;
        }
        this.addPath(targetCode, parentCode);
        if (this.movingForward() && this.targetContains(targetCode)) {
            paths = this.linkPath(parentCode, targetCode, ring);
        }
        if (!this.movingForward() && this.sourceContains(targetCode)) {
            paths = this.linkPath(targetCode, parentCode, ring);
        }
        return paths;
    }
}

