/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class GremlinUtil {
    private static final Set<String> LIMIT_SUFFIXES = ImmutableSet.of((Object)".V()", (Object)".out()", (Object)".in()", (Object)".both()", (Object)".outV()", (Object)".inV()", (Object[])new String[]{".bothV()", ".otherV()", ".E()", ".outE()", ".inE()", ".bothE()", ".path()", ".simplePath()", ".cyclicPath()", ".hasLabel(STR)", ".hasLabel(NUM)"});
    private static final String[] COMPILE_SEARCH_LIST = new String[]{".", "(", ")"};
    private static final String[] COMPILE_TARGET_LIST = new String[]{"\\.", "\\(", "\\)"};
    private static final String[] ESCAPE_SEARCH_LIST = new String[]{"\\", "\"", "'", "\n"};
    private static final String[] ESCAPE_TARGET_LIST = new String[]{"\\\\", "\\\"", "\\'", "\\n"};
    private static final Set<Pattern> LIMIT_PATTERNS = GremlinUtil.compile(LIMIT_SUFFIXES);
    private static final Set<Pattern> IGNORED_PATTERNS = ImmutableSet.of((Object)Pattern.compile("^\\s*//.*"));

    public static String escapeId(Object id) {
        if (!(id instanceof String)) {
            return id.toString();
        }
        String text = (String)id;
        text = StringUtils.replaceEach((String)text, (String[])ESCAPE_SEARCH_LIST, (String[])ESCAPE_TARGET_LIST);
        return (String)GremlinUtil.escape(text);
    }

    public static Object escape(Object object) {
        if (!(object instanceof String)) {
            return object;
        }
        return StringUtils.wrap((String)((String)object), (char)'\'');
    }

    public static String optimizeLimit(String gremlin, int limit) {
        String[] rawLines = StringUtils.split((String)gremlin, (String)"\n");
        ArrayList<String> newLines = new ArrayList<String>(rawLines.length);
        for (String rawLine : rawLines) {
            boolean ignored = IGNORED_PATTERNS.stream().anyMatch(pattern -> pattern.matcher(rawLine).find());
            if (ignored) {
                newLines.add(rawLine);
                continue;
            }
            boolean matched = false;
            for (Pattern pattern2 : LIMIT_PATTERNS) {
                Matcher matcher = pattern2.matcher(rawLine);
                if (!matcher.find()) continue;
                matched = true;
                break;
            }
            if (matched) {
                newLines.add(rawLine + ".limit(" + limit + ")");
                continue;
            }
            newLines.add(rawLine);
        }
        return StringUtils.join(newLines, (String)"\n");
    }

    private static Set<Pattern> compile(Set<String> texts) {
        LinkedHashSet<Pattern> patterns = new LinkedHashSet<Pattern>();
        for (String text : texts) {
            Pattern pattern;
            String regex = StringUtils.replaceEach((String)text, (String[])COMPILE_SEARCH_LIST, (String[])COMPILE_TARGET_LIST);
            if (text.contains("(STR)")) {
                pattern = GremlinUtil.compile(regex.replaceAll("STR", "'[\\\\s\\\\S]+'"));
                patterns.add(pattern);
                pattern = GremlinUtil.compile(regex.replaceAll("STR", "\"[\\\\s\\\\S]+\""));
                patterns.add(pattern);
                continue;
            }
            if (text.contains("(NUM)")) {
                pattern = GremlinUtil.compile(regex.replaceAll("NUM", "[\\\\d]+"));
                patterns.add(pattern);
                continue;
            }
            if (!text.contains("()")) continue;
            pattern = GremlinUtil.compile(regex);
            patterns.add(pattern);
        }
        return patterns;
    }

    private static Pattern compile(String regex) {
        String finalRegex = "(" + regex + ")$";
        return Pattern.compile(finalRegex);
    }
}

