/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;

public class StringDataType
implements DataType {
    public static final StringDataType INSTANCE = new StringDataType();

    @Override
    public int compare(Object object, Object object2) {
        return object.toString().compareTo(object2.toString());
    }

    @Override
    public int getMemory(Object object) {
        return 24 + 2 * object.toString().length();
    }

    @Override
    public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.read(byteBuffer);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            this.write(writeBuffer, objectArray[i]);
        }
    }

    @Override
    public String read(ByteBuffer byteBuffer) {
        int n = DataUtils.readVarInt(byteBuffer);
        return DataUtils.readString(byteBuffer, n);
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object object) {
        String string = object.toString();
        int n = string.length();
        writeBuffer.putVarInt(n).putStringData(string, n);
    }
}

