/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation.maintenance;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.maintenance.MaintenanceTask;

public class DefragmentationParameters {
    public static final String SEPARATOR = "/";
    private final List<String> cacheNames;

    private DefragmentationParameters(List<String> cacheNames) {
        this.cacheNames = cacheNames;
    }

    public static MaintenanceTask toStore(List<String> cacheNames) {
        return new MaintenanceTask("defragmentationMaintenanceTask", "Caches defragmentation", cacheNames.stream().map(String::valueOf).collect(Collectors.joining(SEPARATOR)));
    }

    public static DefragmentationParameters fromStore(MaintenanceTask rawTask) {
        if (rawTask.parameters() == null) {
            return new DefragmentationParameters(Collections.emptyList());
        }
        return new DefragmentationParameters(Arrays.stream(rawTask.parameters().split(SEPARATOR)).collect(Collectors.toList()));
    }

    public List<String> cacheNames() {
        return this.cacheNames;
    }
}

